/*
 * Decompiled with CFR 0.152.
 */
package carmel.type;

import carmel.type.JCVMNumericType;
import carmel.type.TypeException;
import carmel.value.IntValue;
import carmel.value.NumericValue;
import carmel.value.Value;

public class JCVMIntType
extends JCVMNumericType {
    public static final JCVMIntType TYPE = new JCVMIntType();

    private JCVMIntType() {
    }

    public Value createDefaultValue() {
        return new IntValue();
    }

    public NumericValue to(int value) {
        return new IntValue(value);
    }

    public NumericValue createValue(int value) throws IllegalArgumentException {
        return this.to(value);
    }

    public boolean isDoubleWord() {
        return true;
    }

    public String getName() {
        return "i";
    }

    public NumericValue applyUnaryNumOp(int operator, NumericValue value, JCVMNumericType resultType) throws TypeException {
        this.checkType(value);
        int v = ((IntValue)value).getValue();
        switch (operator) {
            case -1: {
                return new IntValue(-v);
            }
            case -2: {
                return resultType.to(v);
            }
            case -3: {
                return resultType.to((byte)v);
            }
        }
        throw new InternalError("Unknown binary numeric operator: ".concat(String.valueOf(String.valueOf(operator))));
    }

    public NumericValue applyBinaryNumOp(int operator, NumericValue value1, NumericValue value2) throws TypeException {
        int result;
        this.checkType(value1);
        this.checkType(value2);
        int v1 = ((IntValue)value1).getValue();
        int v2 = ((IntValue)value2).getValue();
        switch (operator) {
            case 0: {
                result = v1 + v2;
                break;
            }
            case 1: {
                result = v1 - v2;
                break;
            }
            case 2: {
                result = v1 * v2;
                break;
            }
            case 3: {
                result = v1 / v2;
                break;
            }
            case 4: {
                result = v1 % v2;
                break;
            }
            case 5: {
                result = v1 & v2;
                break;
            }
            case 6: {
                result = v1 | v2;
                break;
            }
            case 7: {
                result = v1 ^ v2;
                break;
            }
            case 8: {
                result = v1 << v2;
                break;
            }
            case 9: {
                result = v1 >> v2;
                break;
            }
            case 10: {
                result = v1 >>> v2;
                break;
            }
            case 11: {
                result = v1 == v2 ? 0 : (v1 > v2 ? 1 : -1);
                break;
            }
            default: {
                throw new InternalError("Unknown binary numeric operator: ".concat(String.valueOf(String.valueOf(operator))));
            }
        }
        return new IntValue(result);
    }
}

