/*
 * Decompiled with CFR 0.152.
 */
package carmel.type;

import carmel.type.JCVMNumericType;
import carmel.type.TypeException;
import carmel.value.ByteValue;
import carmel.value.NumericValue;
import carmel.value.Value;

public class JCVMByteType
extends JCVMNumericType {
    public static final JCVMByteType TYPE = new JCVMByteType();

    private JCVMByteType() {
    }

    public Value createDefaultValue() {
        return new ByteValue();
    }

    public NumericValue to(int value) {
        return new ByteValue((byte)value);
    }

    public NumericValue createValue(int value) throws IllegalArgumentException {
        if (value < -128 || value > 127) {
            throw new IllegalArgumentException("Value out of range for byte");
        }
        return this.to(value);
    }

    public String getName() {
        return "b";
    }

    public NumericValue applyUnaryNumOp(int operator, NumericValue value, JCVMNumericType resultType) throws TypeException {
        this.checkType(value);
        byte v = ((ByteValue)value).getValue();
        switch (operator) {
            case -1: {
                return new ByteValue(-v);
            }
            case -3: 
            case -2: {
                return resultType.to(v);
            }
        }
        throw new InternalError("Unknown binary numeric operator: ".concat(String.valueOf(String.valueOf(operator))));
    }

    public NumericValue applyBinaryNumOp(int operator, NumericValue value1, NumericValue value2) throws TypeException {
        int result;
        this.checkType(value1);
        this.checkType(value2);
        byte v1 = ((ByteValue)value1).getValue();
        byte v2 = ((ByteValue)value2).getValue();
        switch (operator) {
            case 0: {
                result = v1 + v2;
                break;
            }
            case 1: {
                result = v1 - v2;
                break;
            }
            case 2: {
                result = v1 * v2;
                break;
            }
            case 3: {
                result = v1 / v2;
                break;
            }
            case 4: {
                result = v1 % v2;
                break;
            }
            case 5: {
                result = v1 & v2;
                break;
            }
            case 6: {
                result = v1 | v2;
                break;
            }
            case 7: {
                result = v1 ^ v2;
                break;
            }
            case 8: {
                result = v1 << v2;
                break;
            }
            case 9: {
                result = v1 >> v2;
                break;
            }
            case 10: {
                result = v1 >>> v2;
                break;
            }
            case 11: {
                result = v1 == v2 ? 0 : (v1 > v2 ? 1 : -1);
                break;
            }
            default: {
                throw new InternalError("Unknown binary numeric operator: ".concat(String.valueOf(String.valueOf(operator))));
            }
        }
        return new ByteValue((byte)result);
    }
}

