/*
 * Decompiled with CFR 0.152.
 */
package carmel.tree;

import carmel.parser.Token;
import carmel.tree.MethodID;
import carmel.tree.TreeClassOrInterface;
import carmel.tree.TreeMethod;
import carmel.tree.TreeStaticField;
import carmel.tree.Visitor;
import carmel.type.NullType;
import carmel.type.ResultType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TreeInterface
extends TreeClassOrInterface {
    public TreeInterface(Token name, int modifiers, List interfaces, Map staticFields, List methods) {
        super(name, modifiers, interfaces, staticFields, methods);
    }

    public boolean isAssignableFrom(ResultType type) {
        return this == type || type == NullType.TYPE || type instanceof TreeClassOrInterface && this.isAssignableFromCollection(((TreeClassOrInterface)type).getInterfaces());
    }

    protected boolean isAssignableFromCollection(Collection types) {
        if (types != null) {
            Iterator i = types.iterator();
            while (i.hasNext()) {
                if (!this.isAssignableFrom((TreeInterface)i.next())) continue;
                return true;
            }
        }
        return false;
    }

    public void visit(Visitor v) throws Exception {
        v.visit(this);
    }

    public TreeStaticField getStaticField(String name) throws NoSuchFieldException {
        try {
            TreeStaticField treeStaticField = this.getDeclaredStaticField(name);
            return treeStaticField;
        }
        catch (NoSuchFieldException e) {
            TreeStaticField treeStaticField = this.getStaticFieldFromInterfaces(name);
            return treeStaticField;
        }
    }

    public TreeMethod getMethod(MethodID methodID) throws NoSuchMethodException {
        try {
            TreeMethod treeMethod = this.getDeclaredMethod(methodID);
            return treeMethod;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (this.interfaces != null) {
                Iterator it = this.interfaces.iterator();
                while (it.hasNext()) {
                    try {
                        TreeMethod treeMethod = ((TreeInterface)it.next()).getMethod(methodID);
                        return treeMethod;
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                    }
                }
            }
            throw new NoSuchMethodException(String.valueOf(String.valueOf(new StringBuffer("Method ").append(methodID).append(" not found"))));
        }
    }
}

