/*
 * Decompiled with CFR 0.152.
 */
package carmel.tree;

import carmel.parser.Token;
import carmel.tree.MethodID;
import carmel.tree.TreeClassOrClassMember;
import carmel.tree.TreeInterface;
import carmel.tree.TreeMethod;
import carmel.tree.TreePackage;
import carmel.tree.TreeStaticField;
import carmel.type.ComponentType;
import carmel.type.JCVMOperandType;
import carmel.type.JCVMReferenceType;
import carmel.type.ReferenceType;
import carmel.type.ResultType;
import carmel.type.TypeException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class TreeClassOrInterface
extends TreeClassOrClassMember
implements ReferenceType,
ComponentType {
    public TreePackage parentPackage = null;
    List interfaces;
    Map staticFields;
    Map methods;
    protected List unmappedMethods;

    public TreeClassOrInterface(Token nameToken, int modifiers, List interfaces, Map staticFields, List methods) {
        super(nameToken, modifiers);
        this.interfaces = interfaces;
        this.staticFields = staticFields;
        this.unmappedMethods = methods;
    }

    public TreePackage getPackage() {
        return this.parentPackage;
    }

    public String getClassName() {
        return super.getName();
    }

    public String getName() {
        if (this.parentPackage == null) {
            return "<unknown package>.".concat(String.valueOf(String.valueOf(this.getClassName())));
        }
        String packageName = this.parentPackage.getName();
        return packageName == null ? this.getClassName() : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(packageName))).append('.').append(this.getClassName())));
    }

    public Collection getInterfaces() {
        return this.interfaces;
    }

    public Collection getDeclaredStaticFields() {
        return this.staticFields.values();
    }

    public TreeStaticField getDeclaredStaticField(String name) throws NoSuchFieldException {
        TreeStaticField field = (TreeStaticField)this.staticFields.get(name);
        if (field != null) {
            return field;
        }
        throw new NoSuchFieldException(String.valueOf(String.valueOf(new StringBuffer("Static field ").append(name).append(" not found"))));
    }

    protected TreeStaticField getStaticFieldFromInterfaces(String name) throws NoSuchFieldException {
        if (this.interfaces != null) {
            Iterator i = this.interfaces.iterator();
            while (i.hasNext()) {
                try {
                    TreeStaticField treeStaticField = ((TreeInterface)i.next()).getStaticField(name);
                    return treeStaticField;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
        }
        throw new NoSuchFieldException(String.valueOf(String.valueOf(new StringBuffer("Static field ").append(name).append(" not found"))));
    }

    public abstract TreeStaticField getStaticField(String var1) throws NoSuchFieldException;

    public Collection getDeclaredMethods() {
        return this.methods.values();
    }

    public TreeMethod getDeclaredMethod(MethodID methodID) throws NoSuchMethodException {
        TreeMethod method = (TreeMethod)this.methods.get(methodID);
        if (method != null) {
            return method;
        }
        throw new NoSuchMethodException(String.valueOf(String.valueOf(new StringBuffer("Method ").append(methodID).append(" not found"))));
    }

    public abstract TreeMethod getMethod(MethodID var1) throws NoSuchMethodException;

    public short getSizeInBytes() {
        return 2;
    }

    public JCVMOperandType getJCVMType() {
        return JCVMReferenceType.TYPE;
    }

    public void checkAssignableFrom(ResultType type) throws TypeException {
        if (!this.isAssignableFrom(type)) {
            throw new TypeException(this, type);
        }
    }

    public boolean isAccessibleFrom(TreeClassOrInterface c) {
        return this == c || this.isPublic() || this.getPackage() == c.getPackage();
    }

    public abstract boolean isAssignableFrom(ResultType var1);
}

