/*
 * Decompiled with CFR 0.152.
 */
package carmel.tree;

import carmel.interpreter.Heap;
import carmel.parser.Token;
import carmel.tree.ClassReference;
import carmel.tree.MethodID;
import carmel.tree.TreeClassOrInterface;
import carmel.tree.TreeConstructor;
import carmel.tree.TreeField;
import carmel.tree.TreeMethod;
import carmel.tree.TreeStaticField;
import carmel.tree.Visitor;
import carmel.type.NullType;
import carmel.type.ResultType;
import carmel.value.ClassValue;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TreeClass
extends TreeClassOrInterface {
    TreeClass superClass = null;
    Map constructors;
    Map fields;
    protected ClassReference superClassReference;
    protected List unmappedConstructors;
    protected short fieldsSizeInBytes;
    protected int fieldIDFrom;
    protected int fieldIDTo = -1;
    protected TreeField[] fieldArray;

    public TreeClass(Token nameToken, int modifiers, ClassReference superClass, List interfaces, Map staticFields, Map fields, List constructors, List methods) {
        super(nameToken, modifiers, interfaces, staticFields, methods);
        this.fields = fields;
        this.superClassReference = superClass;
        this.unmappedConstructors = constructors;
    }

    public TreeClass getSuperClass() {
        return this.superClass;
    }

    public Collection getDeclaredFields() {
        return this.fields.values();
    }

    public TreeStaticField getStaticField(String name) throws NoSuchFieldException {
        try {
            TreeStaticField treeStaticField = this.getDeclaredStaticField(name);
            return treeStaticField;
        }
        catch (NoSuchFieldException e) {
            if (this.superClass != null) {
                try {
                    TreeStaticField treeStaticField = this.superClass.getStaticField(name);
                    return treeStaticField;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            TreeStaticField treeStaticField = this.getStaticFieldFromInterfaces(name);
            return treeStaticField;
        }
    }

    public TreeField getDeclaredField(String name) throws NoSuchFieldException {
        TreeField field = (TreeField)this.fields.get(name);
        if (field != null) {
            return field;
        }
        throw new NoSuchFieldException(String.valueOf(String.valueOf(new StringBuffer("Field ").append(name).append(" not found"))));
    }

    public TreeField getField(int fieldID) {
        if (fieldID < 0) {
            throw new IndexOutOfBoundsException("negative field ID");
        }
        return fieldID < this.fieldIDFrom ? this.superClass.getField(fieldID) : this.fieldArray[fieldID - this.fieldIDFrom];
    }

    public TreeField getField(String name) throws NoSuchFieldException {
        try {
            TreeField treeField = this.getDeclaredField(name);
            return treeField;
        }
        catch (NoSuchFieldException e) {
            if (this.superClass != null) {
                TreeField treeField = this.superClass.getDeclaredField(name);
                return treeField;
            }
            throw e;
        }
    }

    public TreeMethod getMethod(MethodID methodID) throws NoSuchMethodException {
        try {
            TreeMethod treeMethod = this.getDeclaredMethod(methodID);
            return treeMethod;
        }
        catch (NoSuchMethodException e) {
            if (this.superClass != null) {
                TreeMethod method = this.superClass.getMethod(methodID);
                if (method.isPrivate()) {
                    throw new NoSuchMethodException(String.valueOf(String.valueOf(new StringBuffer("Method ").append(methodID).append(" is declared private in class ").append(method.getParentClass().getName()))));
                }
                TreeMethod treeMethod = method;
                return treeMethod;
            }
            throw e;
        }
    }

    public Collection getConstructors() {
        return this.constructors.values();
    }

    public TreeConstructor getConstructor(List parameterTypes) throws NoSuchMethodException {
        TreeConstructor constructor = (TreeConstructor)this.constructors.get(parameterTypes);
        if (constructor != null) {
            return constructor;
        }
        throw new NoSuchMethodException(String.valueOf(String.valueOf(new StringBuffer("Constructor ").append(this.getName()).append(new MethodID("", parameterTypes)).append(" not found"))));
    }

    public TreeConstructor getDefaultConstructor() throws NoSuchMethodException {
        return this.getConstructor(Collections.EMPTY_LIST);
    }

    public boolean isAssignableFrom(ResultType type) {
        return this == type || type == NullType.TYPE || type instanceof TreeClass && this.isAssignableFrom(((TreeClass)type).superClass);
    }

    public ClassValue newInstance(Heap heap) {
        return new ClassValue(heap, this);
    }

    protected int assignFieldIDs() {
        if (this.fieldIDTo == -1) {
            this.fieldIDTo = this.superClass == null ? 0 : (this.fieldIDFrom = this.superClass.assignFieldIDs());
            Collection declaredFields = this.fields.values();
            this.fieldArray = new TreeField[declaredFields.size()];
            this.fieldsSizeInBytes = this.superClass == null ? (short)0 : this.superClass.fieldsSizeInBytes;
            int index = 0;
            Iterator i = declaredFields.iterator();
            while (i.hasNext()) {
                TreeField field = (TreeField)i.next();
                ++this.fieldIDTo;
                field.fieldID = field.fieldID;
                this.fieldsSizeInBytes = (short)(this.fieldsSizeInBytes + field.getType().getSizeInBytes());
                this.fieldArray[index++] = field;
            }
        }
        return this.fieldIDTo;
    }

    public int getFieldIDCount() {
        return this.fieldIDTo;
    }

    public short getFieldsSizeInBytes() {
        return this.fieldsSizeInBytes;
    }

    public void visit(Visitor v) throws Exception {
        v.visit(this);
    }
}

