/*
 * Decompiled with CFR 0.152.
 */
package carmel.tree;

import carmel.interpreter.CarmelClassLoader;
import carmel.parser.ParseException;
import carmel.parser.Token;
import carmel.tree.ClassReference;
import carmel.tree.DefaultVisitor;
import carmel.tree.ExceptionHandler;
import carmel.tree.FieldInstruction;
import carmel.tree.Instruction;
import carmel.tree.InstructionBlock;
import carmel.tree.InvokeConstructorInstruction;
import carmel.tree.InvokeDefiniteMethodInstruction;
import carmel.tree.InvokeInterfaceInstruction;
import carmel.tree.InvokeVirtualInstruction;
import carmel.tree.LocalVariableInstruction;
import carmel.tree.TreeClass;
import carmel.tree.TreeClassMember;
import carmel.tree.TreeClassOrInterface;
import carmel.tree.TreeConstructor;
import carmel.tree.TreeConstructorOrMethod;
import carmel.tree.TreeInterface;
import carmel.tree.TreeMethod;
import carmel.tree.TreePackage;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class LinkPass2Visitor
extends DefaultVisitor {
    protected CarmelClassLoader classLoader;
    protected TreeClassOrInterface currentClass;
    protected int localVariableArraySize;

    public LinkPass2Visitor(CarmelClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void visitPackage(TreePackage p) throws ParseException {
        try {
            this.visitCollection(p.classes.values());
            this.visitCollection(p.interfaces.values());
        }
        catch (ParseException e) {
            e.setSource(p.source);
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalError();
        }
    }

    public void visit(TreeClass c) throws Exception {
        this.currentClass = c;
        if (c.isPublic() && c.superClass != null && c.superClass.hasDefaultAccess()) {
            TreeClass sc = c.superClass;
            while (sc != null) {
                Iterator i = sc.getDeclaredMethods().iterator();
                while (i.hasNext()) {
                    TreeMethod m = (TreeMethod)i.next();
                    if (m.isPublic()) {
                        throw new ParseException(String.valueOf(String.valueOf(new StringBuffer("Cannot extend class ").append(sc.getName()).append(" with default access and public method ").append(m.getNameWithTypes()).append(" with a public class"))), c.nameToken);
                    }
                    if (!m.isProtected()) continue;
                    throw new ParseException(String.valueOf(String.valueOf(new StringBuffer("Cannot extend class ").append(sc.getName()).append(" with default access and protected method ").append(m.getNameWithTypes()).append(" with a public class"))), c.nameToken);
                }
                sc = sc.superClass;
            }
        }
        this.checkClassCircularity(c, new HashSet());
        this.visitCollection(c.constructors.values());
        this.visitCollection(c.methods.values());
        c.assignFieldIDs();
    }

    public void visit(TreeInterface i) throws Exception {
        this.currentClass = i;
        if (i.isPublic()) {
            Iterator it = i.interfaces.iterator();
            while (it.hasNext()) {
                TreeInterface i2 = (TreeInterface)it.next();
                if (!i2.hasDefaultAccess()) continue;
                throw new ParseException(String.valueOf(String.valueOf(new StringBuffer("Cannot extend interface ").append(i2.getName()).append(" with default access with a public interface"))), i.nameToken);
            }
        }
        this.checkInterfaceCircularity(i, new HashSet());
    }

    protected void visitTreeConstructorOrMethod(TreeConstructorOrMethod m) throws Exception {
        this.localVariableArraySize = m.localVariableArraySize;
        if (m.exceptions != null) {
            Iterator i = m.exceptions.iterator();
            Iterator j = m.exceptionReferences.iterator();
            while (i.hasNext()) {
                TreeClass c = (TreeClass)i.next();
                ClassReference r = (ClassReference)j.next();
                if (this.classLoader.throwable.isAssignableFrom(c)) continue;
                throw new ParseException(String.valueOf(String.valueOf(new StringBuffer("java.lang.Throwable expected, ").append(c.getName()).append(" found"))), r.firstToken);
            }
            m.exceptionReferences = null;
        }
        this.visit(m.instructionBlock);
    }

    public void visit(TreeConstructor c) throws Exception {
        this.visitTreeConstructorOrMethod(c);
    }

    protected void checkMethodOverride(TreeMethod method, TreeMethod overriddenMethod) throws ParseException {
        if (overriddenMethod.isPrivate()) {
            return;
        }
        if (overriddenMethod.isPublic() && (method.isPrivate() || method.isProtected() || !method.isPublic())) {
            throw new ParseException("Cannot override method with weaker access privileges, was public in ".concat(String.valueOf(String.valueOf(overriddenMethod.getParentClass().getName()))), method.nameToken);
        }
        if (overriddenMethod.hasDefaultAccess() && !method.hasDefaultAccess()) {
            throw new ParseException(String.valueOf(String.valueOf(new StringBuffer("Cannot override method with default access in ").append(overriddenMethod.getParentClass().getName()).append(" with a different access privilege"))), method.nameToken);
        }
        if (overriddenMethod.isProtected() && method.isPrivate()) {
            throw new ParseException("Cannot override method with weaker access privileges, was protected in ".concat(String.valueOf(String.valueOf(overriddenMethod.getParentClass().getName()))), method.nameToken);
        }
        if (overriddenMethod.isFinal()) {
            throw new ParseException("Cannot override a final method", method.nameToken);
        }
        if (method.getResultType() != overriddenMethod.getResultType()) {
            throw new ParseException(String.valueOf(String.valueOf(new StringBuffer("Cannot override method with a different return type, was ").append(overriddenMethod.getResultType().getName()).append(" in ").append(overriddenMethod.getParentClass().getName()))), method.nameToken);
        }
    }

    public void visit(TreeMethod m) throws Exception {
        Collection interfaces;
        Iterator i;
        this.visitTreeConstructorOrMethod(m);
        Object overriddenMethod = null;
        if (this.currentClass instanceof TreeClass) {
            TreeClass superClass = ((TreeClass)this.currentClass).getSuperClass();
            if (superClass != null) {
                try {
                    this.checkMethodOverride(m, ((TreeClass)this.currentClass).getSuperClass().getMethod(m.methodID));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (this.currentClass.isPublic() && (m.isPublic() || m.isProtected())) {
                i = m.getParameterTypes().iterator();
                while (i.hasNext()) {
                    try {
                        TreeClass c = (TreeClass)i.next();
                        if (!c.hasDefaultAccess()) continue;
                        throw new ParseException(String.valueOf(String.valueOf(new StringBuffer("Public method ").append(m.getNameWithTypes()).append(" in ").append(m.isPublic() ? "public" : "protected").append(" class ").append(this.currentClass.getName()).append(" cannot have parameter ").append(c.getName()).append(" with default access"))), m.nameToken);
                    }
                    catch (ClassCastException classCastException) {
                    }
                }
            }
        }
        if ((interfaces = this.currentClass.getInterfaces()) != null) {
            i = interfaces.iterator();
            while (i.hasNext()) {
                try {
                    this.checkMethodOverride(m, ((TreeInterface)i.next()).getMethod(m.methodID));
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
        }
    }

    public void visit(InstructionBlock i) throws Exception {
        Instruction instruction = i.firstInstruction;
        do {
            instruction.visit(this);
        } while ((instruction = instruction.next) != null);
        this.visitCollection(i.handlers);
    }

    public void visit(ExceptionHandler h) throws Exception {
        if (h.catchType != null && !this.classLoader.throwable.isAssignableFrom(h.catchType)) {
            throw new ParseException(String.valueOf(String.valueOf(new StringBuffer("java.lang.Throwable expected, ").append(h.catchType.getName()).append(" found"))), h.catchTypeReference.firstToken);
        }
        h.catchTypeReference = null;
    }

    protected void visitStaticFieldInstruction(FieldInstruction i) throws Exception {
        this.checkMemberAccess(i.field, i.fieldReference.firstToken);
        i.fieldReference = null;
    }

    protected void visitFieldInstruction(FieldInstruction i) throws Exception {
        this.checkMemberAccess(i.field, i.fieldReference.firstToken);
        i.fieldReference = null;
    }

    protected void visitLocalVariableInstruction(LocalVariableInstruction i) throws Exception {
        if (i.index + (i.type.isDoubleWord() ? 1 : 0) >= this.localVariableArraySize) {
            throw new ParseException("Local variable index invalid", i.token);
        }
    }

    public void visit(InvokeConstructorInstruction i) throws Exception {
        try {
            i.constructor = i.constructorReference.parentClass.getConstructor(i.constructorReference.types);
            this.checkMemberAccess(i.constructor, i.constructorReference.firstToken);
        }
        catch (NoSuchMethodException e) {
            throw new ParseException(e.getMessage(), i.constructorReference.firstToken);
        }
        i.constructorReference = null;
    }

    public void visit(InvokeDefiniteMethodInstruction i) throws Exception {
        try {
            i.method = i.methodReference.parentClass.getMethod(i.methodReference.methodID);
            this.checkMemberAccess(i.method, i.methodReference.firstToken);
        }
        catch (NoSuchMethodException e) {
            throw new ParseException(e.getMessage(), i.methodReference.firstToken);
        }
        i.methodReference = null;
    }

    public void visit(InvokeVirtualInstruction i) throws Exception {
        try {
            TreeMethod method = i.parentClass.getMethod(i.methodID);
            if (method.isStatic()) {
                throw new ParseException("Static method not allowed here", i.methodReference.firstToken);
            }
            this.checkMemberAccess(method, i.methodReference.firstToken);
        }
        catch (NoSuchMethodException e) {
            throw new ParseException(e.getMessage(), i.methodReference.firstToken);
        }
        i.methodReference = null;
    }

    public void visit(InvokeInterfaceInstruction i) throws Exception {
        try {
            TreeMethod method = i.parentInterface.getMethod(i.methodID);
            if (method.isStatic()) {
                throw new ParseException("Static method not allowed here", i.methodReference.firstToken);
            }
            this.checkMemberAccess(method, i.methodReference.firstToken);
        }
        catch (NoSuchMethodException e) {
            throw new ParseException(e.getMessage(), i.methodReference.firstToken);
        }
        i.methodReference = null;
    }

    protected void checkClassCircularity(TreeClass c, Set superClasses) throws ParseException {
        if (!superClasses.add(c)) {
            throw new ParseException("Class circularity error involving ".concat(String.valueOf(String.valueOf(c.getName()))), c.nameToken);
        }
        if (c.superClass != null) {
            this.checkClassCircularity(c.superClass, superClasses);
        }
    }

    protected void checkInterfaceCircularity(TreeInterface i, HashSet superInterfaces) throws ParseException {
        if (!superInterfaces.add(i)) {
            throw new ParseException("Class circularity error involving ".concat(String.valueOf(String.valueOf(i.getName()))), i.nameToken);
        }
        Iterator it = i.interfaces.iterator();
        while (it.hasNext()) {
            this.checkInterfaceCircularity((TreeInterface)it.next(), (HashSet)superInterfaces.clone());
        }
    }

    protected void checkMemberAccess(TreeClassMember m, Token token) throws ParseException {
        if (!m.isAccessibleFrom(this.currentClass)) {
            throw new ParseException("Class does not have the right to access ".concat(String.valueOf(String.valueOf(m.getName()))), token);
        }
    }
}

