/*
 * Decompiled with CFR 0.152.
 */
package carmel.tree;

import carmel.interpreter.CarmelClassLoader;
import carmel.parser.LexOrParseException;
import carmel.parser.ParseException;
import carmel.parser.Token;
import carmel.tree.AddressInstruction;
import carmel.tree.ClassReference;
import carmel.tree.ConstructorReference;
import carmel.tree.DefaultInstructionVisitor;
import carmel.tree.ExceptionHandler;
import carmel.tree.FieldInstruction;
import carmel.tree.FieldReference;
import carmel.tree.GotoInstruction;
import carmel.tree.ImportDeclaration;
import carmel.tree.Instruction;
import carmel.tree.InstructionBlock;
import carmel.tree.InvokeConstructorInstruction;
import carmel.tree.InvokeDefiniteMethodInstruction;
import carmel.tree.InvokeInterfaceInstruction;
import carmel.tree.InvokeVirtualInstruction;
import carmel.tree.LookupSwitchInstruction;
import carmel.tree.MethodID;
import carmel.tree.MethodReference;
import carmel.tree.NewArrayInstruction;
import carmel.tree.NewClassInstruction;
import carmel.tree.PackageReference;
import carmel.tree.ReturnInstruction;
import carmel.tree.StaticFieldInstruction;
import carmel.tree.StoreInstruction;
import carmel.tree.TableSwitchInstruction;
import carmel.tree.ThrowInstruction;
import carmel.tree.TreeAbstractField;
import carmel.tree.TreeClass;
import carmel.tree.TreeClassMember;
import carmel.tree.TreeClassOrInterface;
import carmel.tree.TreeConstructor;
import carmel.tree.TreeConstructorOrMethod;
import carmel.tree.TreeField;
import carmel.tree.TreeInterface;
import carmel.tree.TreeMethod;
import carmel.tree.TreePackage;
import carmel.tree.TreeStaticField;
import carmel.tree.TypeInstruction;
import carmel.tree.Visitee;
import carmel.tree.Visitor;
import carmel.type.ArrayType;
import carmel.type.ComponentType;
import carmel.type.JCVMByteType;
import carmel.type.JCVMOperandType;
import carmel.type.JCVMShortType;
import carmel.type.ReferenceType;
import carmel.type.ResultType;
import carmel.type.Type;
import carmel.type.VoidType;
import carmel.value.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LinkPass1Visitor
extends DefaultInstructionVisitor
implements Visitor {
    CarmelClassLoader classLoader;
    Map addressMap;
    int maxLocalVariableIndex;
    TreePackage currentPackage;
    TreeClassOrInterface currentClass;
    TreeConstructorOrMethod currentMethod;

    public LinkPass1Visitor(CarmelClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void visitPackage(TreePackage p) throws LexOrParseException {
        try {
            this.currentPackage = p;
            this.visit(p.imports);
            this.visitCollection(p.classes.values());
            this.visitCollection(p.interfaces.values());
            p.imports = null;
        }
        catch (LexOrParseException e) {
            e.setSource(p.source);
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalError();
        }
    }

    public void visit(ImportDeclaration i) throws Exception {
        Iterator<Object> it = i.packageImports.iterator();
        i.packageImports = new HashSet();
        while (it.hasNext()) {
            PackageReference r = (PackageReference)it.next();
            String filename = CarmelClassLoader.getPackageFilename(r.name);
            if (ClassLoader.getSystemResourceAsStream(filename) == null) {
                throw new ParseException(String.valueOf(String.valueOf(new StringBuffer("File for package import ").append(r.name).append(" not found by appending ").append(filename).append(" to each path in CLASSPATH"))), r.firstToken);
            }
            i.packageImports.add(r.name);
        }
        it = i.classImports.entrySet().iterator();
        i.classImports = new HashMap();
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            i.classImports.put(e.getKey(), this.resolveClassOrInterface((ClassReference)e.getValue()));
        }
    }

    protected void visitClassOrInterface(TreeClassOrInterface c) throws Exception {
        Iterator i;
        this.currentClass = c;
        c.parentPackage = this.currentPackage;
        if (c.interfaces != null) {
            i = c.interfaces.iterator();
            c.interfaces = new LinkedList();
            while (i.hasNext()) {
                c.interfaces.add(this.resolveInterface((ClassReference)i.next()));
            }
        }
        this.visitCollection(c.staticFields.values());
        i = c.unmappedMethods.iterator();
        c.methods = new HashMap();
        while (i.hasNext()) {
            TreeMethod m = (TreeMethod)i.next();
            this.visit(m);
            if (c.methods.put(m.methodID, m) == null) continue;
            throw new ParseException("Duplicate definition of method ".concat(String.valueOf(String.valueOf(m.getName()))), m.nameToken);
        }
    }

    public void visit(TreeClass c) throws Exception {
        if (c.superClassReference != null) {
            c.superClass = this.resolveClass(c.superClassReference);
        }
        this.visitClassOrInterface(c);
        if (c.superClassReference == null) {
            try {
                TreeClass object = (TreeClass)this.classLoader.loadClass("java.lang.Object", 0);
                c.superClass = c == object ? null : object;
            }
            catch (ClassCastException e) {
                throw new ParseException("Implied superclass java.lang.Object must be a class", c.nameToken);
            }
            catch (ClassNotFoundException e) {
                throw new ParseException("Implied superclass java.lang.Object not found", c.nameToken);
            }
        } else if (c.superClass.isFinal()) {
            throw new ParseException("Cannot extend a final class", c.superClassReference.firstToken);
        }
        this.visitCollection(c.fields.values());
        Iterator i = c.unmappedConstructors.iterator();
        c.constructors = new HashMap();
        while (i.hasNext()) {
            TreeConstructor co = (TreeConstructor)i.next();
            this.visit(co);
            if (c.constructors.put(co.parameterTypes, co) == null) continue;
            throw new ParseException("Duplicate definition of constructor", co.nameToken);
        }
    }

    public void visit(TreeInterface i) throws Exception {
        this.visitClassOrInterface(i);
    }

    protected void visitClassMember(TreeClassMember m) {
        m.parentClass = this.currentClass;
    }

    protected void visitConstructorOrMethod(TreeConstructorOrMethod m) throws Exception {
        this.currentMethod = m;
        this.visitClassMember(m);
        m.parameterTypes = this.resolveTypeList(m.parameterTypes, new ArrayList(m.parameterTypes.size()));
        m.exceptions = this.resolveClassList(m.exceptionReferences);
        m.instructionBlock.visit(this);
        m.localVariableArraySize = this.maxLocalVariableIndex + 1;
    }

    public void visit(TreeConstructor c) throws Exception {
        this.maxLocalVariableIndex = c.parameterTypes.size() + 1;
        this.visitConstructorOrMethod(c);
    }

    public void visit(TreeMethod m) throws Exception {
        if (!this.currentClass.isAbstract() && m.isAbstract()) {
            throw new ParseException("Abstract method not allowed in non-abstract class", m.nameToken);
        }
        if (this.currentClass instanceof TreeInterface && m.isNative()) {
            throw new ParseException("Native method not allowed in interface", m.nameToken);
        }
        this.maxLocalVariableIndex = m.parameterTypes.size();
        if (!m.isStatic()) {
            ++this.maxLocalVariableIndex;
        }
        m.resultType = this.resolveType(m.resultType);
        this.visitConstructorOrMethod(m);
        m.methodID = new MethodID(m.getMemberName(), m.getParameterTypes());
    }

    protected void visitAbstractField(TreeAbstractField f) throws Exception {
        this.visitClassMember(f);
        f.type = (Type)this.resolveType(f.type);
    }

    public void visit(TreeStaticField f) throws Exception {
        this.visitAbstractField(f);
        f.value.visit(this);
    }

    public void visit(TreeField f) throws Exception {
        this.visitAbstractField(f);
    }

    public void visit(Value v) throws Exception {
        v.type = (Type)this.resolveType(v.type);
    }

    public void visit(InstructionBlock i) throws Exception {
        this.addressMap = i.addressMap;
        i.addressMap = null;
        Instruction instruction = i.firstInstruction;
        while (instruction.next != null) {
            instruction.visit(this);
            instruction = instruction.next;
        }
        instruction.visit(this);
        if (!(instruction instanceof ReturnInstruction || instruction instanceof GotoInstruction || instruction instanceof ThrowInstruction)) {
            throw new ParseException("Last instruction does not return a value, throw an exception or goto another address", instruction.token);
        }
        this.visitCollection(i.handlers);
    }

    public void visit(ExceptionHandler h) throws Exception {
        h.catchType = this.resolveClass(h.catchTypeReference);
        h.fromIndex = this.resolveAddress((Token)h.fromToken).blockIndex;
        h.toIndex = this.resolveAddress((Token)h.toToken).blockIndex;
        h.targetInstruction = this.resolveAddress(h.targetToken);
        if (h.fromIndex > h.toIndex) {
            throw new ParseException("Invalid exception handler address range", h.fromToken);
        }
        if (h.targetInstruction.blockIndex >= h.fromIndex && h.targetInstruction.blockIndex <= h.toIndex) {
            throw new ParseException("Target address within catch range", h.targetToken);
        }
        h.targetToken = null;
        h.toToken = null;
        h.fromToken = null;
    }

    protected void visitAddressInstruction(AddressInstruction i) throws Exception {
        i.instruction = this.resolveAddress(i.addressToken);
        i.addressToken = null;
    }

    public void visit(StoreInstruction i) throws Exception {
        if (i.index >= this.maxLocalVariableIndex) {
            this.maxLocalVariableIndex = i.type.isDoubleWord() ? i.index + 1 : i.index;
        }
    }

    public void visit(InvokeConstructorInstruction i) throws Exception {
        this.visit(i.constructorReference);
    }

    public void visit(InvokeDefiniteMethodInstruction i) throws Exception {
        this.visit(i.methodReference);
        if (!(i.methodReference.parentClass instanceof TreeClass)) {
            throw new ParseException("Interface method not allowed here", i.methodReference.firstToken);
        }
    }

    public void visit(InvokeVirtualInstruction i) throws Exception {
        i.methodReference.visit(this);
        if (!(i.methodReference.parentClass instanceof TreeClass)) {
            throw new ParseException("Interface method not allowed here", i.methodReference.firstToken);
        }
        i.parentClass = (TreeClass)i.methodReference.parentClass;
        i.methodID = i.methodReference.methodID;
    }

    public void visit(InvokeInterfaceInstruction i) throws Exception {
        i.methodReference.visit(this);
        if (!(i.methodReference.parentClass instanceof TreeInterface)) {
            throw new ParseException("Class method not allowed here", i.methodReference.firstToken);
        }
        i.parentInterface = (TreeInterface)i.methodReference.parentClass;
        i.methodID = i.methodReference.methodID;
    }

    protected void visitStaticFieldInstruction(StaticFieldInstruction i) throws Exception {
        FieldReference r = i.fieldReference;
        TreeClassOrInterface c = r.classReference == null ? this.currentClass : this.resolveClassOrInterface(r.classReference);
        try {
            i.field = c.getDeclaredStaticField(r.name);
        }
        catch (NoSuchFieldException e) {
            throw new ParseException(e.getMessage(), r.firstToken);
        }
    }

    protected void visitFieldInstruction(FieldInstruction i) throws Exception {
        FieldReference r = i.fieldReference;
        try {
            TreeClass c = r.classReference == null ? (TreeClass)this.currentClass : this.resolveClass(r.classReference);
            i.field = c.getDeclaredField(r.name);
        }
        catch (ClassCastException e) {
            throw new ParseException("Interface does not have non-static fields", r.firstToken);
        }
        catch (NoSuchFieldException e) {
            throw new ParseException(e.getMessage(), r.firstToken);
        }
    }

    protected void visitTypeInstruction(TypeInstruction i) throws Exception {
        i.type = (ReferenceType)this.resolveType(i.type);
    }

    public void visit(NewArrayInstruction i) throws Exception {
        this.resolveType(i.type);
    }

    public void visit(NewClassInstruction i) throws Exception {
        i.classType = this.resolveClass(i.classReference);
        if (i.classType.isAbstract()) {
            throw new ParseException("Cannot instantiate an abstract class", i.classReference.firstToken);
        }
        i.classReference = null;
    }

    public void visit(LookupSwitchInstruction i) throws Exception {
        super.visit(i);
        Iterator it = i.switches.entrySet().iterator();
        i.switches = new HashMap();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            i.switches.put(entry.getKey(), this.resolveAddress((Token)entry.getValue()));
        }
    }

    public void visit(TableSwitchInstruction i) throws Exception {
        super.visit(i);
        Iterator it = i.addresses.iterator();
        i.addresses = new ArrayList(i.addresses.size());
        while (it.hasNext()) {
            i.addresses.add(this.resolveAddress((Token)it.next()));
        }
    }

    public void visit(ReturnInstruction i) throws Exception {
        if (this.currentMethod instanceof TreeConstructor) {
            if (i.type != null) {
                throw new ParseException("Constructor can only return void", i.token);
            }
        } else {
            TreeMethod method = (TreeMethod)this.currentMethod;
            if (i.type == null) {
                if (method.resultType != VoidType.TYPE) {
                    throw new ParseException(String.valueOf(String.valueOf(new StringBuffer("Method is declared to return ").append(method.resultType.getName()).append(", but returns void"))), i.token);
                }
            } else {
                if (method.resultType == VoidType.TYPE) {
                    throw new ParseException("Method is declared to return void, but returns ".concat(String.valueOf(String.valueOf(i.type.getName()))), i.token);
                }
                JCVMOperandType type = ((Type)method.resultType).getJCVMType();
                if (type == JCVMByteType.TYPE) {
                    type = JCVMShortType.TYPE;
                }
                if (!type.equals(i.type)) {
                    throw new ParseException(String.valueOf(String.valueOf(new StringBuffer("Method is declared to return ").append(method.resultType.getName()).append(", but returns ").append(i.type.getName()))), i.token);
                }
            }
        }
    }

    public void visit(MethodReference r) throws Exception {
        r.parentClass = r.classReference == null ? this.currentClass : this.resolveClassOrInterface(r.classReference);
        r.methodID.types = this.resolveTypeList(r.methodID.types, new ArrayList(r.methodID.types.size()));
    }

    public void visit(ConstructorReference r) throws Exception {
        try {
            r.parentClass = r.classReference == null ? (TreeClass)this.currentClass : this.resolveClass(r.classReference);
        }
        catch (ClassCastException e) {
            throw new ParseException("Cannot construct an interface", r.firstToken);
        }
        r.types = this.resolveTypeList(r.types, new ArrayList(r.types.size()));
    }

    protected void visitCollection(Collection c) throws Exception {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            ((Visitee)i.next()).visit(this);
        }
    }

    protected TreeClassOrInterface loadClass(String name, Token token) throws ClassNotFoundException, LexOrParseException {
        TreeClassOrInterface c = this.classLoader.loadClass(name, 0);
        this.checkClassAccess(c, token);
        return c;
    }

    protected TreeInterface resolveInterface(ClassReference reference) throws Exception {
        try {
            TreeInterface treeInterface = (TreeInterface)this.resolveType(reference);
            return treeInterface;
        }
        catch (ClassCastException e) {
            throw new ParseException("Interface expected", reference.firstToken);
        }
    }

    protected TreeClass resolveClass(ClassReference reference) throws Exception {
        try {
            TreeClass treeClass = (TreeClass)this.resolveType(reference);
            return treeClass;
        }
        catch (ClassCastException e) {
            throw new ParseException("Class expected", reference.firstToken);
        }
    }

    protected TreeClassOrInterface resolveClassOrInterface(ClassReference reference) throws Exception {
        try {
            TreeClassOrInterface treeClassOrInterface = (TreeClassOrInterface)this.resolveType(reference);
            return treeClassOrInterface;
        }
        catch (ClassCastException e) {
            throw new ParseException("Class or interface expected", reference.firstToken);
        }
    }

    protected ResultType resolveType(ResultType reference) throws LexOrParseException {
        if (reference instanceof ClassReference) {
            TreeClassOrInterface temp;
            TreeClassOrInterface c;
            ClassReference r = (ClassReference)reference;
            if (r.packageReference == null || r.packageReference.name.equals(this.currentPackage.getName())) {
                c = this.currentPackage.getClassOrInterface(r.name);
                if (c != null) {
                    return c;
                }
                c = (TreeClassOrInterface)this.currentPackage.imports.classImports.get(r.name);
                if (c != null) {
                    return c;
                }
                if (r.packageReference != null) {
                    throw new ParseException(String.valueOf(String.valueOf(new StringBuffer("Class ").append(r.getName()).append(" not found"))), r.firstToken);
                }
            } else {
                try {
                    TreeClassOrInterface treeClassOrInterface = this.loadClass(r.getName(), r.firstToken);
                    return treeClassOrInterface;
                }
                catch (ClassNotFoundException e) {
                    throw new ParseException(e.getMessage(), r.firstToken);
                }
            }
            try {
                c = this.loadClass(r.name, r.firstToken);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            String suffix = ".".concat(String.valueOf(String.valueOf(r.name)));
            try {
                temp = this.loadClass("java.lang".concat(String.valueOf(String.valueOf(suffix))), r.firstToken);
                if (c != null) {
                    throw new ParseException(String.valueOf(String.valueOf(r.name)).concat(" exists in more than one package import"), r.firstToken);
                }
                c = temp;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Iterator i = this.currentPackage.imports.packageImports.iterator();
            while (i.hasNext()) {
                try {
                    temp = this.loadClass(String.valueOf(String.valueOf((String)i.next())).concat(String.valueOf(String.valueOf(suffix))), r.firstToken);
                    if (c == null) {
                        c = temp;
                        continue;
                    }
                    throw new ParseException(String.valueOf(String.valueOf(r.name)).concat(" exists in more than one package import"), r.firstToken);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            if (c != null) {
                return c;
            }
            throw new ParseException(String.valueOf(String.valueOf(new StringBuffer("Class ").append(r.name).append(" not found"))), r.firstToken);
        }
        if (reference instanceof ArrayType) {
            ((ArrayType)reference).componentType = (ComponentType)this.resolveType(((ArrayType)reference).componentType);
        }
        return reference;
    }

    protected List resolveClassList(List list) throws Exception {
        return list == null ? null : this.resolveClassList(list, new LinkedList());
    }

    protected List resolveClassList(List oldList, List newList) throws Exception {
        if (oldList == null) {
            return null;
        }
        Iterator i = oldList.iterator();
        while (i.hasNext()) {
            newList.add(this.resolveClass((ClassReference)i.next()));
        }
        return newList;
    }

    protected List resolveTypeList(List oldList, List newList) throws Exception {
        if (oldList == null) {
            return null;
        }
        Iterator i = oldList.iterator();
        while (i.hasNext()) {
            newList.add(this.resolveType((ResultType)i.next()));
        }
        return newList;
    }

    protected Instruction resolveAddress(Token token) throws ParseException {
        Instruction instruction = (Instruction)this.addressMap.get(token.image);
        if (instruction == null) {
            throw new ParseException(String.valueOf(String.valueOf(new StringBuffer("Address ").append(token.image).append(" not found"))), token);
        }
        return instruction;
    }

    protected void checkClassAccess(TreeClassOrInterface c, Token token) throws ParseException {
        if (!c.isAccessibleFrom(this.currentClass)) {
            throw new ParseException("Class does not have the right to access ".concat(String.valueOf(String.valueOf(c.getName()))), token);
        }
    }
}

