/*
 * Decompiled with CFR 0.152.
 */
package carmel.parser;

public class TokenMgrError
extends Error {
    public static final int LEXICAL_ERROR = 0;
    public static final int STATIC_LEXER_ERROR = 1;
    public static final int INVALID_LEXICAL_STATE = 2;
    public static final int LOOP_DETECTED = 3;
    int errorCode;
    protected int line;
    protected int column;
    protected String errorMessage;

    public TokenMgrError(String message, int reason) {
        super(message);
        this.errorCode = reason;
    }

    public TokenMgrError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar, int reason) {
        this(String.valueOf(String.valueOf(new StringBuffer("Lexical error: encountered ").append(EOFSeen ? "<EOF>" : String.valueOf(String.valueOf(new StringBuffer("\"").append(TokenMgrError.addEscapes(String.valueOf(curChar))).append("\"")))).append("".equals(errorAfter) ? "" : String.valueOf(String.valueOf(new StringBuffer(" after \"").append(TokenMgrError.addEscapes(errorAfter)).append("\"")))))), reason);
        this.line = errorLine;
        this.column = errorColumn;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getErrorType() {
        return this.errorCode;
    }

    protected static final String addEscapes(String str) {
        StringBuffer retval = new StringBuffer();
        block8: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block8;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block8;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block8;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block8;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block8;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block8;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000".concat(String.valueOf(String.valueOf(Integer.toString(ch, 16))));
                        retval.append("\\u".concat(String.valueOf(String.valueOf(s.substring(s.length() - 4, s.length())))));
                        continue block8;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }

    static {
        LEXICAL_ERROR = 0;
        STATIC_LEXER_ERROR = 1;
        INVALID_LEXICAL_STATE = 2;
        LOOP_DETECTED = 3;
    }
}

