/*
 * Decompiled with CFR 0.152.
 */
package carmel.parser;

import carmel.interpreter.CarmelSource;
import carmel.interpreter.Heap;
import carmel.parser.JavaCharStream;
import carmel.parser.LexException;
import carmel.parser.LexOrParseException;
import carmel.parser.ParseException;
import carmel.parser.ParserConstants;
import carmel.parser.ParserTokenManager;
import carmel.parser.Token;
import carmel.parser.TokenMgrError;
import carmel.tree.ArrayLengthInstruction;
import carmel.tree.ArrayLoadInstruction;
import carmel.tree.ArrayStoreInstruction;
import carmel.tree.CheckCastInstruction;
import carmel.tree.ClassReference;
import carmel.tree.ConstructorReference;
import carmel.tree.DupInstruction;
import carmel.tree.ExceptionHandler;
import carmel.tree.FieldReference;
import carmel.tree.GetFieldInstruction;
import carmel.tree.GetStaticInstruction;
import carmel.tree.GotoInstruction;
import carmel.tree.IfInstruction;
import carmel.tree.ImportDeclaration;
import carmel.tree.IncInstruction;
import carmel.tree.InstanceOfInstruction;
import carmel.tree.Instruction;
import carmel.tree.InstructionBlock;
import carmel.tree.InvokeConstructorInstruction;
import carmel.tree.InvokeDefiniteInstruction;
import carmel.tree.InvokeDefiniteMethodInstruction;
import carmel.tree.InvokeInterfaceInstruction;
import carmel.tree.InvokeVirtualInstruction;
import carmel.tree.JsrInstruction;
import carmel.tree.LoadInstruction;
import carmel.tree.LookupSwitchInstruction;
import carmel.tree.MethodReference;
import carmel.tree.NameTokenList;
import carmel.tree.NewArrayInstruction;
import carmel.tree.NewClassInstruction;
import carmel.tree.NewInstruction;
import carmel.tree.NopInstruction;
import carmel.tree.NumOpInstruction;
import carmel.tree.PackageReference;
import carmel.tree.PopInstruction;
import carmel.tree.PushInstruction;
import carmel.tree.PutFieldInstruction;
import carmel.tree.PutStaticInstruction;
import carmel.tree.RetInstruction;
import carmel.tree.ReturnInstruction;
import carmel.tree.StoreInstruction;
import carmel.tree.SwapInstruction;
import carmel.tree.TableSwitchInstruction;
import carmel.tree.ThrowInstruction;
import carmel.tree.TreeClass;
import carmel.tree.TreeConstructor;
import carmel.tree.TreeField;
import carmel.tree.TreeInterface;
import carmel.tree.TreeMethod;
import carmel.tree.TreePackage;
import carmel.tree.TreeStaticField;
import carmel.type.ArrayType;
import carmel.type.BooleanType;
import carmel.type.ByteType;
import carmel.type.ComponentType;
import carmel.type.IntType;
import carmel.type.JCVMByteType;
import carmel.type.JCVMIntType;
import carmel.type.JCVMNumericType;
import carmel.type.JCVMOperandType;
import carmel.type.JCVMReferenceType;
import carmel.type.JCVMShortType;
import carmel.type.JCVMType;
import carmel.type.NumericType;
import carmel.type.PrimitiveType;
import carmel.type.ReferenceType;
import carmel.type.ResultType;
import carmel.type.ShortType;
import carmel.type.Type;
import carmel.type.TypeException;
import carmel.type.VoidType;
import carmel.value.ArrayValue;
import carmel.value.ByteValue;
import carmel.value.IntValue;
import carmel.value.NullValue;
import carmel.value.NumericValue;
import carmel.value.PrimitiveValue;
import carmel.value.Value;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Parser
implements ParserConstants {
    protected Heap heap;
    protected CarmelSource source;
    public ParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[72];
    private final int[] jj_la1_0 = new int[]{0x2000000, 0, 0, 1569267712, 1569202176, 0, 0x200000, 0, 1560813568, 1560813568, 131072, 0x100000, 2101927936, 2101927936, 131072, 2101927936, 2101927936, 0, 0, 0, 262144, 262144, 0, 0, 0, 0, 0, 541638656, 524288, 0, 0, 0, 0, 541114368, 0, 541114368, 0, 541114368, 541114368, 541097984, 0, 0, 541114368, 0, 0, 0, 262144, 0, 0, 0, 262144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final int[] jj_la1_1 = new int[]{0, 2007433088, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2007433092, 2007433088, 0, 2007433092, 2007433088, 0, 0, 0, 34, 2, 0, 0, 1, 0, 0, 2007433088, 0, 0, 2007433088, 2007433092, 1, 2007433092, 0, 2007433088, 0, 2007433088, 0, 0, 2007433088, 0, 2007433088, 2007433088, 2007433088, 0, 2, 0, 0, 0, 2, 0, 0, 2007433088, -134742128, 0, 32, 0, 0, 2007433088, 0x8000000, 0x8000000, 2007433088, 0, 32, 32, 0, 0, 0, 0, 0, 0};
    private final int[] jj_la1_2 = new int[]{0, 0x5FFFFFF7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x5FFFFFF7, 0x5FFFFFF7, 0, 0x5FFFFFF7, 0x5FFFFFF7, 0, 0, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0x5FFFFFF7, 0, 0, 0x5FFFFFF7, 0x5FFFFFF7, 0, 0x5FFFFFF7, 0, 0x5FFFFFF7, 0, 0x5FFFFFF7, 0, 0, 0x5FFFFFF7, 0, 0x5FFFFFF7, 0x5FFFFFF7, 0x5FFFFFF7, 0, Integer.MIN_VALUE, 0, 0, Integer.MIN_VALUE, 0, 0, Integer.MIN_VALUE, 0x5FFFFFF7, 63, 896, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0x5FFFFFF7, 0, 0, 0x5FFFFFF7, 960, Integer.MIN_VALUE, Integer.MIN_VALUE, 960, 832, 896, 768, 0x7FFF0000, 64512};
    private final int[] jj_la1_3 = new int[]{0, 4, 256, 32, 32, 4096, 0, 8192, 0, 0, 0, 0, 4, 4, 0, 4, 4, 4096, 1024, 262144, 65859, 65603, 4096, 1024, 0, 288, 4096, 4, 0, 1024, 4, 4, 0, 4, 1024, 4, 1024, 4, 0, 0, 4, 4096, 4, 4, 4, 4096, 65603, 64, 65536, 3, 0, 65536, 0, 131076, 0, 0, 0, 65603, 0, 4, 0, 0, 4, 0, 65603, 0, 0, 0, 0, 0, 0, 0};
    private final JJCalls[] jj_2_rtns = new JJCalls[10];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public Parser(Heap heap, CarmelSource source) throws IOException {
        this(source.openReader());
        this.heap = heap;
        this.source = source;
    }

    public List parsePackages() throws LexOrParseException {
        try {
            List list = this.parsePackages_aux();
            return list;
        }
        catch (TokenMgrError e) {
            if (e.getErrorType() == 0) {
                throw new LexException(e.getMessage(), this.source, e.getLine(), e.getColumn());
            }
            throw e;
        }
        catch (ParseException e) {
            e.setSource(this.source);
            throw e;
        }
    }

    public TreePackage parsePackage() throws LexOrParseException {
        try {
            TreePackage treePackage = this.parsePackage_aux();
            return treePackage;
        }
        catch (TokenMgrError e) {
            if (e.getErrorType() == 0) {
                throw new LexException(e.getMessage(), this.source, e.getLine(), e.getColumn());
            }
            throw e;
        }
        catch (ParseException e) {
            e.setSource(this.source);
            throw e;
        }
    }

    protected static int addModifier(int modifiers, Token t, int allowedModifiers) throws ParseException {
        int newModifier = 0;
        switch (t.kind) {
            case 28: {
                newModifier = 1;
                break;
            }
            case 27: {
                newModifier = 4;
                break;
            }
            case 26: {
                newModifier = 2;
                break;
            }
            case 30: {
                newModifier = 8;
                break;
            }
            case 19: {
                newModifier = 16;
                break;
            }
            case 13: {
                newModifier = 1024;
                break;
            }
            case 24: {
                newModifier = 256;
                break;
            }
            default: {
                throw new Error("Unknown modifier: ".concat(String.valueOf(String.valueOf(t.image))));
            }
        }
        if ((newModifier & allowedModifiers) == 0) {
            throw new ParseException(String.valueOf(String.valueOf(new StringBuffer("Modifier ").append(t.image).append(" not allowed here"))), t);
        }
        if ((newModifier & modifiers) != 0) {
            throw new ParseException(String.valueOf(String.valueOf(new StringBuffer("Modifier ").append(t.image).append(" declared twice"))), t);
        }
        if (((modifiers |= newModifier) & 1) != 0 && (modifiers & 4) != 0) {
            throw new ParseException("Invalid combination of modifiers: public and protected", t);
        }
        if ((modifiers & 1) != 0 && (modifiers & 2) != 0) {
            throw new ParseException("Invalid combination of modifiers: public and private", t);
        }
        if ((modifiers & 4) != 0 && (modifiers & 2) != 0) {
            throw new ParseException("Invalid combination of modifiers: protected and private", t);
        }
        if ((modifiers & 0x400) != 0) {
            if ((modifiers & 0x10) != 0) {
                throw new ParseException("Invalid combination of modifiers: abstract and final", t);
            }
            if ((modifiers & 8) != 0) {
                throw new ParseException("Invalid combination of modifiers: abstract and static", t);
            }
            if ((modifiers & 0x100) != 0) {
                throw new ParseException("Invalid combination of modifiers: abstract and native", t);
            }
        }
        return modifiers;
    }

    public final List parsePackages_aux() throws ParseException {
        LinkedList<TreePackage> packages = new LinkedList<TreePackage>();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 25: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            TreePackage p = this.parsePackageOptionalNameNoEOF();
            packages.add(p);
        }
        this.jj_consume_token(0);
        return packages;
    }

    public final TreePackage parsePackage_aux() throws ParseException {
        Token t = this.jj_consume_token(25);
        NameTokenList name = this.name();
        byte[] aid = this.aid();
        this.jj_consume_token(101);
        TreePackage p = this.parsePackageNoNameNoEOF(t, name.getName(), aid);
        this.jj_consume_token(0);
        return p;
    }

    public final TreePackage parsePackageOptionalNameNoEOF() throws ParseException {
        NameTokenList name = null;
        byte[] aid = null;
        Token t = this.jj_consume_token(25);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 98: {
                name = this.name();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 104: {
                aid = this.aid();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        this.jj_consume_token(101);
        TreePackage p = this.parsePackageNoNameNoEOF(t, name == null ? null : name.getName(), aid);
        return p;
    }

    public final TreePackage parsePackageNoNameNoEOF(Token token, String name, byte[] aid) throws ParseException {
        ImportDeclaration imports;
        HashMap<String, TreeInterface> interfaces;
        HashMap<String, TreeClass> classes;
        block9: {
            classes = new HashMap<String, TreeClass>();
            interfaces = new HashMap<String, TreeInterface>();
            HashSet nameSet = new HashSet();
            imports = this.importDeclarations(nameSet);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 16: 
                    case 19: 
                    case 23: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 30: 
                    case 101: {
                        break;
                    }
                    default: {
                        this.jj_la1[3] = this.jj_gen;
                        break block9;
                    }
                }
                if (this.jj_2_1(Integer.MAX_VALUE)) {
                    TreeClass cl = this.classDeclaration(nameSet);
                    classes.put(cl.getClassName(), cl);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 19: 
                    case 23: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 30: {
                        TreeInterface in = this.interfaceDeclaration(nameSet);
                        interfaces.put(in.getClassName(), in);
                        continue block7;
                    }
                    case 101: {
                        this.jj_consume_token(101);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[4] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return new TreePackage(this.source, token, name, aid, imports, classes, interfaces);
    }

    public final byte[] aid() throws ParseException {
        LinkedList<NumericValue> aidBytes = new LinkedList<NumericValue>();
        Token t = this.jj_consume_token(104);
        NumericValue value = this.numericLiteral(JCVMIntType.TYPE);
        aidBytes.add(value);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 108: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(108);
            value = this.numericLiteral(JCVMIntType.TYPE);
            aidBytes.add(value);
        }
        this.jj_consume_token(105);
        int size = aidBytes.size();
        if (5 > size || size > 16) {
            throw new ParseException("Package AID must be between 5 and 16 bytes", t);
        }
        byte[] aid = new byte[size];
        int index = 0;
        Iterator i = aidBytes.iterator();
        while (i.hasNext()) {
            aid[index++] = (byte)((IntValue)i.next()).getValue();
        }
        return aid;
    }

    public final ImportDeclaration importDeclarations(Set nameSet) throws ParseException {
        boolean packageImport = false;
        HashMap<String, ClassReference> classImports = new HashMap<String, ClassReference>();
        HashSet<PackageReference> packageImports = new HashSet<PackageReference>();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block6;
                }
            }
            Token t = this.jj_consume_token(21);
            NameTokenList name = this.name();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 109: {
                    this.jj_consume_token(109);
                    this.jj_consume_token(113);
                    packageImport = true;
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                }
            }
            this.jj_consume_token(101);
            if (packageImport) {
                if (!packageImports.add(new PackageReference(name))) {
                    throw new ParseException("Package already imported", t);
                }
                packageImport = false;
                continue;
            }
            if (!name.hasPrefix()) {
                throw new ParseException("Import class not fully qualified", t);
            }
            ClassReference c = new ClassReference(name);
            if (!nameSet.add(c.name)) {
                throw new ParseException(String.valueOf(String.valueOf(new StringBuffer("A class called ").append(c.name).append(" has already been imported"))), t);
            }
            classImports.put(c.name, c);
        }
        return new ImportDeclaration(packageImports, classImports);
    }

    public final int modifiers(int allowedModifiers) throws ParseException {
        int modifiers = 0;
        block12: while (true) {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: 
                case 19: 
                case 24: 
                case 26: 
                case 27: 
                case 28: 
                case 30: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block12;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 28: {
                    t = this.jj_consume_token(28);
                    break;
                }
                case 27: {
                    t = this.jj_consume_token(27);
                    break;
                }
                case 26: {
                    t = this.jj_consume_token(26);
                    break;
                }
                case 13: {
                    t = this.jj_consume_token(13);
                    break;
                }
                case 19: {
                    t = this.jj_consume_token(19);
                    break;
                }
                case 30: {
                    t = this.jj_consume_token(30);
                    break;
                }
                case 24: {
                    t = this.jj_consume_token(24);
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            modifiers = Parser.addModifier(modifiers, t, allowedModifiers);
        }
        return modifiers;
    }

    public final TreeClass classDeclaration(Set nameSet) throws ParseException {
        Token name;
        int modifiers;
        LinkedList methods;
        LinkedList constructors;
        HashMap fields;
        HashMap staticFields;
        List interfaces;
        ClassReference superClass;
        block16: {
            superClass = null;
            interfaces = null;
            staticFields = new HashMap();
            fields = new HashMap();
            constructors = new LinkedList();
            methods = new LinkedList();
            modifiers = this.modifiers(1041);
            this.jj_consume_token(16);
            name = this.identifier();
            if (!nameSet.add(name.image)) {
                throw new ParseException("Duplicate definition of ".concat(String.valueOf(String.valueOf(name.image))), name);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: {
                    this.jj_consume_token(17);
                    superClass = this.classReference();
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: {
                    this.jj_consume_token(20);
                    interfaces = this.classReferenceList();
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                }
            }
            this.jj_consume_token(104);
            block12: while (true) {
                int memberModifiers;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 19: 
                    case 22: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 34: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 49: 
                    case 50: 
                    case 53: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 94: 
                    case 98: {
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        break block16;
                    }
                }
                if (this.jj_2_2(Integer.MAX_VALUE)) {
                    this.constructorDeclaration(constructors, name.image);
                    continue;
                }
                if (this.jj_2_3(Integer.MAX_VALUE)) {
                    memberModifiers = this.modifiers(1311);
                    this.unmodifiedMethodDeclaration(methods, memberModifiers);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 19: 
                    case 22: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 49: 
                    case 50: 
                    case 53: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 94: 
                    case 98: {
                        memberModifiers = this.modifiers(31);
                        this.unmodifiedFieldDeclaration(staticFields, fields, memberModifiers);
                        continue block12;
                    }
                }
                break;
            }
            this.jj_la1[13] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(105);
        return new TreeClass(name, modifiers, superClass, interfaces, staticFields, fields, constructors, methods);
    }

    public final TreeInterface interfaceDeclaration(Set nameSet) throws ParseException {
        Token name;
        int modifiers;
        LinkedList methods;
        HashMap fields;
        List interfaces;
        block12: {
            interfaces = null;
            fields = new HashMap();
            methods = new LinkedList();
            modifiers = this.modifiers(1025);
            this.jj_consume_token(23);
            name = this.identifier();
            if (!nameSet.add(name.image)) {
                throw new ParseException("Duplicate definition of ".concat(String.valueOf(String.valueOf(name.image))), name);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: {
                    this.jj_consume_token(17);
                    interfaces = this.classReferenceList();
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                }
            }
            this.jj_consume_token(104);
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 19: 
                    case 22: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 34: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 49: 
                    case 50: 
                    case 53: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 94: 
                    case 98: {
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        break block12;
                    }
                }
                if (this.jj_2_4(Integer.MAX_VALUE)) {
                    this.modifiers(1025);
                    this.unmodifiedMethodDeclaration(methods, 1025);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 19: 
                    case 22: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 49: 
                    case 50: 
                    case 53: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 94: 
                    case 98: {
                        this.modifiers(25);
                        this.unmodifiedFieldDeclaration(fields, null, 25);
                        continue block9;
                    }
                }
                break;
            }
            this.jj_la1[16] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(105);
        return new TreeInterface(name, modifiers, interfaces, fields, methods);
    }

    public final void unmodifiedFieldDeclaration(Map staticFields, Map fields, int modifiers) throws ParseException {
        Type type = this.type();
        this.fieldDeclarator(staticFields, fields, modifiers, type);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 108: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(108);
            this.fieldDeclarator(staticFields, fields, modifiers, type);
        }
        this.jj_consume_token(101);
    }

    public final void fieldDeclarator(Map staticFields, Map fields, int modifiers, Type type) throws ParseException {
        Token t = null;
        Value initialValue = null;
        Token name = this.identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 106: {
                t = this.jj_consume_token(106);
                this.jj_consume_token(107);
                try {
                    type = new ArrayType((ComponentType)type);
                    break;
                }
                catch (ClassCastException e) {
                    throw new ParseException("Field is declared twice as an array", t);
                }
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 114: {
                t = this.jj_consume_token(114);
                initialValue = this.fieldInitializer(type);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        if ((modifiers & 8) == 0) {
            if (initialValue != null) {
                throw new ParseException("Initialiser not allowed non-static field", t);
            }
            if (staticFields.containsKey(name.image) || fields.put(name.image, new TreeField(name, modifiers, type)) != null) {
                throw new ParseException("Duplicate definition of field ".concat(String.valueOf(String.valueOf(name.image))), name);
            }
        } else {
            if ((modifiers & 0x10) != 0 && initialValue == null) {
                throw new ParseException("Uninitialised static final field", name);
            }
            if (fields.containsKey(name.image) || staticFields.put(name.image, new TreeStaticField(name, modifiers, type, initialValue)) != null) {
                throw new ParseException("Duplicate definition of field ".concat(String.valueOf(String.valueOf(name.image))), name);
            }
        }
    }

    public final Value fieldInitializer(Type type) throws ParseException {
        Value v;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 104: {
                v = this.arrayInitializer(type);
                break;
            }
            case 18: 
            case 33: 
            case 95: 
            case 96: 
            case 97: 
            case 102: 
            case 112: {
                v = this.primitiveLiteral(type);
                break;
            }
            case 37: {
                v = this.nullLiteral(type.getJCVMType());
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return v;
    }

    public final ArrayValue arrayInitializer(Type type) throws ParseException {
        PrimitiveType componentType;
        LinkedList<PrimitiveValue> values = new LinkedList<PrimitiveValue>();
        Token t = this.jj_consume_token(104);
        try {
            componentType = (PrimitiveType)((ArrayType)type).getComponentType();
        }
        catch (ClassCastException e) {
            throw new ParseException("Invalid array initializer", t);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: 
            case 33: 
            case 95: 
            case 96: 
            case 97: 
            case 102: 
            case 112: {
                PrimitiveValue value = this.primitiveLiteral(componentType);
                values.add(value);
                while (this.jj_2_5(2)) {
                    this.jj_consume_token(108);
                    value = this.primitiveLiteral(componentType);
                    values.add(value);
                }
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 108: {
                this.jj_consume_token(108);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
        this.jj_consume_token(105);
        return new ArrayValue(this.heap, (ArrayType)type, values);
    }

    public final void unmodifiedMethodDeclaration(List methods, int modifiers) throws ParseException {
        Token t;
        List exceptions = null;
        InstructionBlock instructionBlock = null;
        ResultType resultType = this.resultType();
        Token name = this.identifier();
        List parameterTypes = this.formalParameters();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 106: {
                t = this.jj_consume_token(106);
                this.jj_consume_token(107);
                try {
                    resultType = new ArrayType((ComponentType)resultType);
                    break;
                }
                catch (ClassCastException e) {
                    if (resultType instanceof VoidType) {
                        throw new ParseException("Array of void not allowed", t);
                    }
                    throw new ParseException("Method return type declared twice as array", t);
                }
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                this.jj_consume_token(32);
                exceptions = this.classReferenceList();
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 104: {
                t = this.jj_consume_token(104);
                if ((modifiers & 0x500) != 0) {
                    throw new ParseException("Body not allowed for abstract or native method", t);
                }
                instructionBlock = this.instructionBlock();
                this.jj_consume_token(105);
                break;
            }
            case 101: {
                t = this.jj_consume_token(101);
                if ((modifiers & 0x500) != 0) break;
                throw new ParseException("Body required for non-abstract, non-native method", t);
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        methods.add(new TreeMethod(name, modifiers, resultType, parameterTypes, exceptions, instructionBlock));
    }

    public final List formalParameters() throws ParseException {
        ArrayList parameterTypes = new ArrayList();
        HashSet names = new HashSet();
        this.jj_consume_token(102);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 19: 
            case 22: 
            case 29: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 98: {
                this.formalParameter(names, parameterTypes);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 108: {
                            break;
                        }
                        default: {
                            this.jj_la1[26] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(108);
                    this.formalParameter(names, parameterTypes);
                }
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        this.jj_consume_token(103);
        return parameterTypes;
    }

    public final void formalParameter(Set names, List parameterTypes) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
            }
        }
        Type type = this.type();
        block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 98: {
                Token name = this.identifier();
                if (!names.add(name.image)) {
                    throw new ParseException("Duplicate definition of parameter ".concat(String.valueOf(String.valueOf(name.image))), name);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 106: {
                        Token t = this.jj_consume_token(106);
                        this.jj_consume_token(107);
                        try {
                            type = new ArrayType((ComponentType)type);
                            break block4;
                        }
                        catch (ClassCastException e) {
                            throw new ParseException("Parameter type declared twice as an array", t);
                        }
                    }
                }
                this.jj_la1[29] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
            }
        }
        parameterTypes.add(type);
    }

    public final void constructorDeclaration(List constructors, String className) throws ParseException {
        Token name;
        List exceptions = null;
        int modifiers = this.modifiers(7);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                this.jj_consume_token(34);
                name = this.jj_consume_token(38);
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 98: {
                name = this.identifier();
                if (name.image.equals(className)) break;
                throw new ParseException("Method return type missing", name);
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        List parameterTypes = this.formalParameters();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                this.jj_consume_token(32);
                exceptions = this.classReferenceList();
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
            }
        }
        this.jj_consume_token(104);
        InstructionBlock instructionBlock = this.instructionBlock();
        this.jj_consume_token(105);
        constructors.add(new TreeConstructor(name, modifiers, parameterTypes, exceptions, instructionBlock));
    }

    public final ResultType resultType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                this.jj_consume_token(34);
                return VoidType.TYPE;
            }
            case 14: 
            case 15: 
            case 22: 
            case 29: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 98: {
                Type type = this.type();
                return type;
            }
        }
        this.jj_la1[33] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Type type() throws ParseException {
        ComponentType type = this.componentType();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 106: {
                this.jj_consume_token(106);
                this.jj_consume_token(107);
                return new ArrayType(type);
            }
        }
        this.jj_la1[34] = this.jj_gen;
        return type;
    }

    public final ArrayType arrayType() throws ParseException {
        ComponentType type = this.componentType();
        this.jj_consume_token(106);
        this.jj_consume_token(107);
        return new ArrayType(type);
    }

    public final ComponentType componentType() throws ParseException {
        ComponentType type;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 22: 
            case 29: {
                type = this.primitiveType();
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 98: {
                type = this.classReference();
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return type;
    }

    public final ClassReference classReference() throws ParseException {
        NameTokenList name = this.name();
        return new ClassReference(name);
    }

    public final ReferenceType referenceType() throws ParseException {
        ClassReference type;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 22: 
            case 29: {
                PrimitiveType type2 = this.primitiveType();
                this.jj_consume_token(106);
                this.jj_consume_token(107);
                return new ArrayType(type2);
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 98: {
                type = this.classReference();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 106: {
                        this.jj_consume_token(106);
                        this.jj_consume_token(107);
                        return new ArrayType(type);
                    }
                }
                this.jj_la1[36] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return type;
    }

    public final PrimitiveType primitiveType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                return BooleanType.TYPE;
            }
            case 15: 
            case 22: 
            case 29: {
                NumericType type = this.primitiveNumericType();
                return type;
            }
        }
        this.jj_la1[38] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final NumericType primitiveNumericType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                return ByteType.TYPE;
            }
            case 29: {
                this.jj_consume_token(29);
                return ShortType.TYPE;
            }
            case 22: {
                this.jj_consume_token(22);
                return IntType.TYPE;
            }
        }
        this.jj_la1[39] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Token identifier() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 98: {
                t = this.jj_consume_token(98);
                break;
            }
            case 39: {
                t = this.jj_consume_token(39);
                break;
            }
            case 40: {
                t = this.jj_consume_token(40);
                break;
            }
            case 41: {
                t = this.jj_consume_token(41);
                break;
            }
            case 42: {
                t = this.jj_consume_token(42);
                break;
            }
            case 43: {
                t = this.jj_consume_token(43);
                break;
            }
            case 44: {
                t = this.jj_consume_token(44);
                break;
            }
            case 45: {
                t = this.jj_consume_token(45);
                break;
            }
            case 46: {
                t = this.jj_consume_token(46);
                break;
            }
            case 47: {
                t = this.jj_consume_token(47);
                break;
            }
            case 49: {
                t = this.jj_consume_token(49);
                break;
            }
            case 50: {
                t = this.jj_consume_token(50);
                break;
            }
            case 53: {
                t = this.jj_consume_token(53);
                break;
            }
            case 55: {
                t = this.jj_consume_token(55);
                break;
            }
            case 56: {
                t = this.jj_consume_token(56);
                break;
            }
            case 57: {
                t = this.jj_consume_token(57);
                break;
            }
            case 58: {
                t = this.jj_consume_token(58);
                break;
            }
            case 60: {
                t = this.jj_consume_token(60);
                break;
            }
            case 61: {
                t = this.jj_consume_token(61);
                break;
            }
            case 62: {
                t = this.jj_consume_token(62);
                break;
            }
            case 64: {
                t = this.jj_consume_token(64);
                break;
            }
            case 65: {
                t = this.jj_consume_token(65);
                break;
            }
            case 66: {
                t = this.jj_consume_token(66);
                break;
            }
            case 68: {
                t = this.jj_consume_token(68);
                break;
            }
            case 69: {
                t = this.jj_consume_token(69);
                break;
            }
            case 70: {
                t = this.jj_consume_token(70);
                break;
            }
            case 71: {
                t = this.jj_consume_token(71);
                break;
            }
            case 72: {
                t = this.jj_consume_token(72);
                break;
            }
            case 73: {
                t = this.jj_consume_token(73);
                break;
            }
            case 74: {
                t = this.jj_consume_token(74);
                break;
            }
            case 75: {
                t = this.jj_consume_token(75);
                break;
            }
            case 76: {
                t = this.jj_consume_token(76);
                break;
            }
            case 77: {
                t = this.jj_consume_token(77);
                break;
            }
            case 78: {
                t = this.jj_consume_token(78);
                break;
            }
            case 79: {
                t = this.jj_consume_token(79);
                break;
            }
            case 80: {
                t = this.jj_consume_token(80);
                break;
            }
            case 81: {
                t = this.jj_consume_token(81);
                break;
            }
            case 82: {
                t = this.jj_consume_token(82);
                break;
            }
            case 83: {
                t = this.jj_consume_token(83);
                break;
            }
            case 84: {
                t = this.jj_consume_token(84);
                break;
            }
            case 85: {
                t = this.jj_consume_token(85);
                break;
            }
            case 86: {
                t = this.jj_consume_token(86);
                break;
            }
            case 87: {
                t = this.jj_consume_token(87);
                break;
            }
            case 88: {
                t = this.jj_consume_token(88);
                break;
            }
            case 89: {
                t = this.jj_consume_token(89);
                break;
            }
            case 90: {
                t = this.jj_consume_token(90);
                break;
            }
            case 91: {
                t = this.jj_consume_token(91);
                break;
            }
            case 92: {
                t = this.jj_consume_token(92);
                break;
            }
            case 94: {
                t = this.jj_consume_token(94);
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t;
    }

    public final FieldReference fieldName() throws ParseException {
        NameTokenList name = this.name();
        return new FieldReference(name);
    }

    public final List methodTypes() throws ParseException {
        ArrayList<Type> types = new ArrayList<Type>();
        this.jj_consume_token(102);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 22: 
            case 29: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 98: {
                Type type = this.type();
                types.add(type);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 108: {
                            break;
                        }
                        default: {
                            this.jj_la1[41] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(108);
                    type = this.type();
                    types.add(type);
                }
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
            }
        }
        this.jj_consume_token(103);
        return types;
    }

    public final void constructorReferenceLookAhead() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 98: {
                this.name();
                this.jj_consume_token(109);
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
        this.jj_consume_token(38);
    }

    public final ConstructorReference constructorReference() throws ParseException {
        NameTokenList name = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 98: {
                name = this.name();
                this.jj_consume_token(109);
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
            }
        }
        Token initToken = this.jj_consume_token(38);
        List types = this.methodTypes();
        if (name == null) {
            name = new NameTokenList(new LinkedList());
        }
        name.add(initToken);
        return new ConstructorReference(name, types);
    }

    public final MethodReference methodReference() throws ParseException {
        NameTokenList name = this.name();
        List types = this.methodTypes();
        return new MethodReference(name, types);
    }

    public final NameTokenList name() throws ParseException {
        LinkedList<Token> names = new LinkedList<Token>();
        Token t = this.identifier();
        names.add(t);
        while (this.jj_2_6(2)) {
            this.jj_consume_token(109);
            t = this.identifier();
            names.add(t);
        }
        return new NameTokenList(names);
    }

    public final List classReferenceList() throws ParseException {
        LinkedList<ClassReference> classes = new LinkedList<ClassReference>();
        ClassReference c = this.classReference();
        classes.add(c);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 108: {
                    break;
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(108);
            c = this.classReference();
            classes.add(c);
        }
        return classes;
    }

    public final PrimitiveValue primitiveLiteral(Type type) throws ParseException {
        NumericValue value;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 95: 
            case 96: 
            case 97: 
            case 102: 
            case 112: {
                value = this.numericLiteral(type.getJCVMType());
                break;
            }
            case 18: 
            case 33: {
                value = this.booleanLiteral(type);
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final NumericValue numericLiteral(JCVMType type) throws ParseException {
        String s;
        int radix;
        Token t;
        Token minusToken = null;
        NumericType castType = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 102: {
                this.jj_consume_token(102);
                castType = this.primitiveNumericType();
                this.jj_consume_token(103);
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 112: {
                minusToken = this.jj_consume_token(112);
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 95: {
                t = this.jj_consume_token(95);
                radix = 10;
                s = t.image;
                break;
            }
            case 96: {
                t = this.jj_consume_token(96);
                radix = 16;
                s = t.image.substring(2);
                break;
            }
            case 97: {
                t = this.jj_consume_token(97);
                radix = 8;
                s = t.image.substring(1);
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        try {
            int value;
            int n = value = minusToken == null ? Integer.parseInt(s, radix) : Integer.parseInt("-".concat(String.valueOf(String.valueOf(s))), radix);
            if (castType != null) {
                JCVMNumericType castJCVMType = (JCVMNumericType)castType.getJCVMType();
                NumericValue numericValue = castJCVMType.applyUnaryNumOp(-2, castJCVMType.to(value), (JCVMNumericType)type);
                return numericValue;
            }
            NumericValue numericValue = ((JCVMNumericType)type).createValue(value);
            return numericValue;
        }
        catch (ClassCastException e) {
            throw new ParseException("Number not expected here", minusToken == null ? t : minusToken);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid number: ".concat(String.valueOf(String.valueOf(e.getMessage()))), minusToken == null ? t : minusToken);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage(), minusToken == null ? t : minusToken);
        }
        catch (TypeException e) {
            throw new InternalError("Not expecting a type exception from applyUnaryNumOp");
        }
    }

    public final ByteValue booleanLiteral(Type type) throws ParseException {
        ByteValue value;
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: {
                t = this.jj_consume_token(33);
                value = new ByteValue(1);
                break;
            }
            case 18: {
                t = this.jj_consume_token(18);
                value = new ByteValue(0);
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (type == BooleanType.TYPE) {
            return value;
        }
        throw new ParseException("Boolean value not allowed here", t);
    }

    public final NullValue nullLiteral(JCVMType type) throws ParseException {
        Token t = this.jj_consume_token(37);
        if (type == JCVMReferenceType.TYPE) {
            return NullValue.NULL;
        }
        throw new ParseException("Null only allowed for reference types", t);
    }

    public final int integerConstant() throws ParseException {
        Token minusToken = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 112: {
                minusToken = this.jj_consume_token(112);
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
            }
        }
        Token t = this.jj_consume_token(95);
        try {
            int n = minusToken == null ? Integer.parseInt(t.image) : Integer.parseInt("-".concat(String.valueOf(String.valueOf(t.image))));
            return n;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid number: ".concat(String.valueOf(String.valueOf(e.getMessage()))), minusToken == null ? t : minusToken);
        }
    }

    public final int decimalNumeral() throws ParseException {
        Token t = this.jj_consume_token(95);
        try {
            int n = Integer.parseInt(t.image);
            return n;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid number: ".concat(String.valueOf(String.valueOf(e.getMessage()))), t);
        }
    }

    public final Token address() throws ParseException {
        Token t = this.jj_consume_token(95);
        return t;
    }

    public final InstructionBlock instructionBlock() throws ParseException {
        Instruction firstInstruction;
        ArrayList instructions = new ArrayList();
        int index = 0;
        HashMap addressMap = new HashMap();
        LinkedList<ExceptionHandler> handlers = new LinkedList<ExceptionHandler>();
        ClassReference catchType = null;
        Instruction prevInstruction = firstInstruction = this.instruction(addressMap, index++);
        while (this.jj_2_7(2)) {
            Instruction instruction;
            prevInstruction = prevInstruction.next = (instruction = this.instruction(addressMap, index++));
        }
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 95: {
                    break;
                }
                default: {
                    this.jj_la1[52] = this.jj_gen;
                    break block8;
                }
            }
            Token from = this.address();
            this.jj_consume_token(112);
            Token to = this.address();
            this.jj_consume_token(110);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 113: {
                    this.jj_consume_token(113);
                    catchType = null;
                    break;
                }
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 49: 
                case 50: 
                case 53: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 60: 
                case 61: 
                case 62: 
                case 64: 
                case 65: 
                case 66: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 94: 
                case 98: {
                    catchType = this.classReference();
                    break;
                }
                default: {
                    this.jj_la1[53] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jj_consume_token(111);
            Token target = this.address();
            handlers.add(new ExceptionHandler(from, to, target, catchType));
        }
        return new InstructionBlock(firstInstruction, handlers, addressMap);
    }

    public final Instruction instruction(Map addressMap, int index) throws ParseException {
        Instruction i;
        Token address = this.address();
        this.jj_consume_token(110);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: {
                i = this.nopInstruction();
                break;
            }
            case 40: {
                i = this.pushInstruction();
                break;
            }
            case 41: {
                i = this.popInstruction();
                break;
            }
            case 42: {
                i = this.dupInstruction();
                break;
            }
            case 43: {
                i = this.swapInstruction();
                break;
            }
            case 44: {
                i = this.numOpInstruction();
                break;
            }
            case 45: {
                i = this.loadInstruction();
                break;
            }
            case 46: {
                i = this.storeInstruction();
                break;
            }
            case 47: {
                i = this.incInstruction();
                break;
            }
            case 36: {
                i = this.gotoInstruction();
                break;
            }
            case 48: {
                i = this.ifInstruction();
                break;
            }
            case 49: {
                i = this.lookupSwitchInstruction();
                break;
            }
            case 50: {
                i = this.tableSwitchInstruction();
                break;
            }
            case 52: {
                i = this.newInstruction();
                break;
            }
            case 53: {
                i = this.checkCastInstruction();
                break;
            }
            case 54: {
                i = this.instanceOfInstruction();
                break;
            }
            case 55: {
                i = this.getStaticInstruction();
                break;
            }
            case 56: {
                i = this.putStaticInstruction();
                break;
            }
            case 57: {
                i = this.getFieldInstruction();
                break;
            }
            case 58: {
                i = this.putFieldInstruction();
                break;
            }
            case 60: {
                i = this.invokeDefiniteInstruction();
                break;
            }
            case 62: {
                i = this.invokeVirtualInstruction();
                break;
            }
            case 61: {
                i = this.invokeInterfaceInstruction();
                break;
            }
            case 63: {
                i = this.returnInstruction();
                break;
            }
            case 64: {
                i = this.arrayLengthInstruction();
                break;
            }
            case 65: {
                i = this.arrayLoadInstruction();
                break;
            }
            case 66: {
                i = this.arrayStoreInstruction();
                break;
            }
            case 67: {
                i = this.throwInstruction();
                break;
            }
            case 68: {
                i = this.jsrInstruction();
                break;
            }
            case 69: {
                i = this.retInstruction();
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        i.address = address.image;
        i.blockIndex = index;
        i.token = address;
        if (addressMap.put(address.image, i) != null) {
            throw new ParseException("Duplicate definition of address ".concat(String.valueOf(String.valueOf(address.image))), address);
        }
        return i;
    }

    public final NopInstruction nopInstruction() throws ParseException {
        this.jj_consume_token(39);
        return new NopInstruction();
    }

    public final PushInstruction pushInstruction() throws ParseException {
        this.jj_consume_token(40);
        JCVMOperandType type = this.operandType();
        Value value = this.constant(type);
        return new PushInstruction(value);
    }

    public final PopInstruction popInstruction() throws ParseException {
        this.jj_consume_token(41);
        int words = this.decimalNumeral();
        return new PopInstruction(words);
    }

    public final DupInstruction dupInstruction() throws ParseException {
        Token t = this.jj_consume_token(42);
        int words = this.decimalNumeral();
        int depth = this.decimalNumeral();
        if (depth > 0 && depth < words) {
            throw new ParseException("Depth must either be 0 or >= to number of words", t);
        }
        return new DupInstruction(words, depth);
    }

    public final SwapInstruction swapInstruction() throws ParseException {
        this.jj_consume_token(43);
        int top = this.decimalNumeral();
        int following = this.decimalNumeral();
        return new SwapInstruction(top, following);
    }

    public final NumOpInstruction numOpInstruction() throws ParseException {
        JCVMNumericType resultType = null;
        this.jj_consume_token(44);
        JCVMNumericType operandType = this.numericType();
        int operator = this.numericOperator();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 71: 
            case 72: 
            case 73: {
                resultType = this.numericType();
                break;
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
            }
        }
        return new NumOpInstruction(operator, operandType, resultType == null ? operandType : resultType);
    }

    public final LoadInstruction loadInstruction() throws ParseException {
        this.jj_consume_token(45);
        JCVMOperandType type = this.wordOperandType();
        int index = this.decimalNumeral();
        return new LoadInstruction(type, index);
    }

    public final StoreInstruction storeInstruction() throws ParseException {
        this.jj_consume_token(46);
        JCVMOperandType type = this.wordOperandType();
        int index = this.decimalNumeral();
        return new StoreInstruction(type, index);
    }

    public final IncInstruction incInstruction() throws ParseException {
        this.jj_consume_token(47);
        JCVMNumericType type = this.wordNumericType();
        int index = this.decimalNumeral();
        NumericValue value = this.numericLiteral(type);
        return new IncInstruction(type, index, value);
    }

    public final GotoInstruction gotoInstruction() throws ParseException {
        this.jj_consume_token(36);
        Token address = this.address();
        return new GotoInstruction(address);
    }

    public final IfInstruction ifInstruction() throws ParseException {
        Value value = null;
        Token t = this.jj_consume_token(48);
        JCVMOperandType type = this.operandType();
        int operator = this.comparisonOperator();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: 
            case 95: {
                value = this.nullComparison(type);
                break;
            }
            default: {
                this.jj_la1[56] = this.jj_gen;
            }
        }
        this.jj_consume_token(36);
        Token address = this.address();
        if (type == JCVMReferenceType.TYPE && operator != 2 && operator != 5) {
            throw new ParseException("Only ne or eq is allowed in this context", t);
        }
        return new IfInstruction(operator, type, value, address);
    }

    public final LookupSwitchInstruction lookupSwitchInstruction() throws ParseException {
        HashMap switches = new HashMap();
        this.jj_consume_token(49);
        JCVMNumericType type = this.wordNumericType();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 95: 
            case 96: 
            case 97: 
            case 102: 
            case 112: {
                this.matchTableEntry(switches, type);
                while (this.jj_2_8(2)) {
                    this.jj_consume_token(108);
                    this.matchTableEntry(switches, type);
                }
                break;
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
            }
        }
        this.jj_consume_token(108);
        this.jj_consume_token(51);
        this.jj_consume_token(111);
        Token address = this.address();
        return new LookupSwitchInstruction(type, switches, address);
    }

    public final void matchTableEntry(Map switches, JCVMNumericType type) throws ParseException {
        NumericValue value = this.numericLiteral(type);
        this.jj_consume_token(111);
        Token address = this.address();
        switches.put(value, address);
    }

    public final TableSwitchInstruction tableSwitchInstruction() throws ParseException {
        Token address;
        LinkedList<Token> addresses = new LinkedList<Token>();
        this.jj_consume_token(50);
        JCVMNumericType type = this.wordNumericType();
        int value = this.integerConstant();
        this.jj_consume_token(111);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 95: {
                    break;
                }
                default: {
                    this.jj_la1[58] = this.jj_gen;
                    break block3;
                }
            }
            address = this.address();
            addresses.add(address);
        }
        this.jj_consume_token(108);
        this.jj_consume_token(51);
        this.jj_consume_token(111);
        address = this.address();
        return new TableSwitchInstruction(type, value, addresses, address);
    }

    public final NewInstruction newInstruction() throws ParseException {
        this.jj_consume_token(52);
        if (this.jj_2_9(Integer.MAX_VALUE)) {
            ArrayType type = this.arrayType();
            return new NewArrayInstruction(type);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 98: {
                ClassReference type = this.classReference();
                return new NewClassInstruction(type);
            }
        }
        this.jj_la1[59] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final CheckCastInstruction checkCastInstruction() throws ParseException {
        this.jj_consume_token(53);
        ReferenceType type = this.referenceType();
        return new CheckCastInstruction(type);
    }

    public final InstanceOfInstruction instanceOfInstruction() throws ParseException {
        this.jj_consume_token(54);
        ReferenceType type = this.referenceType();
        return new InstanceOfInstruction(type);
    }

    public final GetStaticInstruction getStaticInstruction() throws ParseException {
        this.jj_consume_token(55);
        FieldReference field = this.fieldName();
        return new GetStaticInstruction(field);
    }

    public final PutStaticInstruction putStaticInstruction() throws ParseException {
        this.jj_consume_token(56);
        FieldReference field = this.fieldName();
        return new PutStaticInstruction(field);
    }

    public final GetFieldInstruction getFieldInstruction() throws ParseException {
        boolean thisField = false;
        this.jj_consume_token(57);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: {
                this.jj_consume_token(59);
                thisField = true;
                break;
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
            }
        }
        FieldReference field = this.fieldName();
        return new GetFieldInstruction(field, thisField);
    }

    public final PutFieldInstruction putFieldInstruction() throws ParseException {
        boolean thisField = false;
        this.jj_consume_token(58);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: {
                this.jj_consume_token(59);
                thisField = true;
                break;
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
            }
        }
        FieldReference field = this.fieldName();
        return new PutFieldInstruction(field, thisField);
    }

    public final InvokeDefiniteInstruction invokeDefiniteInstruction() throws ParseException {
        this.jj_consume_token(60);
        if (this.jj_2_10(Integer.MAX_VALUE)) {
            ConstructorReference constructorReference = this.constructorReference();
            return new InvokeConstructorInstruction(constructorReference);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 98: {
                MethodReference methodReference = this.methodReference();
                return new InvokeDefiniteMethodInstruction(methodReference);
            }
        }
        this.jj_la1[62] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final InvokeVirtualInstruction invokeVirtualInstruction() throws ParseException {
        this.jj_consume_token(62);
        MethodReference method = this.methodReference();
        return new InvokeVirtualInstruction(method);
    }

    public final InvokeInterfaceInstruction invokeInterfaceInstruction() throws ParseException {
        this.jj_consume_token(61);
        MethodReference method = this.methodReference();
        return new InvokeInterfaceInstruction(method);
    }

    public final ReturnInstruction returnInstruction() throws ParseException {
        JCVMOperandType type = null;
        this.jj_consume_token(63);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                type = this.operandType();
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
            }
        }
        return new ReturnInstruction(type);
    }

    public final ArrayLengthInstruction arrayLengthInstruction() throws ParseException {
        this.jj_consume_token(64);
        return new ArrayLengthInstruction();
    }

    public final ArrayLoadInstruction arrayLoadInstruction() throws ParseException {
        this.jj_consume_token(65);
        JCVMOperandType type = this.operandType();
        return new ArrayLoadInstruction(type);
    }

    public final ArrayStoreInstruction arrayStoreInstruction() throws ParseException {
        this.jj_consume_token(66);
        JCVMOperandType type = this.operandType();
        return new ArrayStoreInstruction(type);
    }

    public final ThrowInstruction throwInstruction() throws ParseException {
        this.jj_consume_token(67);
        return new ThrowInstruction();
    }

    public final JsrInstruction jsrInstruction() throws ParseException {
        this.jj_consume_token(68);
        Token address = this.address();
        return new JsrInstruction(address);
    }

    public final RetInstruction retInstruction() throws ParseException {
        this.jj_consume_token(69);
        int index = this.decimalNumeral();
        return new RetInstruction(index);
    }

    public final Value constant(JCVMOperandType type) throws ParseException {
        Value v;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                v = this.nullLiteral(type);
                break;
            }
            case 95: 
            case 96: 
            case 97: 
            case 102: 
            case 112: {
                v = this.numericLiteral(type);
                break;
            }
            default: {
                this.jj_la1[64] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return v;
    }

    public final Value nullComparison(JCVMOperandType type) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 95: {
                Token t = this.jj_consume_token(95);
                if (!"0".equals(t.image)) {
                    throw new ParseException(String.valueOf(String.valueOf(new StringBuffer("Encountered \"").append(t.image).append("\" was expecting \"0\" or \"null\""))), t);
                }
                try {
                    NumericValue numericValue = ((JCVMNumericType)type).createValue(0);
                    return numericValue;
                }
                catch (ClassCastException e) {
                    throw new ParseException("0 not a valid argument in this context", t);
                }
            }
            case 37: {
                NullValue v = this.nullLiteral(type);
                return v;
            }
        }
        this.jj_la1[65] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final JCVMOperandType operandType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 71: 
            case 72: 
            case 73: {
                JCVMNumericType type = this.numericType();
                return type;
            }
            case 70: {
                this.jj_consume_token(70);
                return JCVMReferenceType.TYPE;
            }
        }
        this.jj_la1[66] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final JCVMOperandType wordOperandType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 72: 
            case 73: {
                JCVMNumericType type = this.wordNumericType();
                return type;
            }
            case 70: {
                this.jj_consume_token(70);
                return JCVMReferenceType.TYPE;
            }
        }
        this.jj_la1[67] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final JCVMNumericType numericType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 72: 
            case 73: {
                JCVMNumericType type = this.wordNumericType();
                return type;
            }
            case 71: {
                this.jj_consume_token(71);
                return JCVMByteType.TYPE;
            }
        }
        this.jj_la1[68] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final JCVMNumericType wordNumericType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 73: {
                this.jj_consume_token(73);
                return JCVMIntType.TYPE;
            }
            case 72: {
                this.jj_consume_token(72);
                return JCVMShortType.TYPE;
            }
        }
        this.jj_la1[69] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int numericOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 80: {
                this.jj_consume_token(80);
                return -1;
            }
            case 81: {
                this.jj_consume_token(81);
                return 0;
            }
            case 82: {
                this.jj_consume_token(82);
                return 1;
            }
            case 83: {
                this.jj_consume_token(83);
                return 2;
            }
            case 84: {
                this.jj_consume_token(84);
                return 3;
            }
            case 85: {
                this.jj_consume_token(85);
                return 4;
            }
            case 86: {
                this.jj_consume_token(86);
                return 5;
            }
            case 87: {
                this.jj_consume_token(87);
                return 6;
            }
            case 88: {
                this.jj_consume_token(88);
                return 7;
            }
            case 89: {
                this.jj_consume_token(89);
                return 8;
            }
            case 90: {
                this.jj_consume_token(90);
                return 9;
            }
            case 91: {
                this.jj_consume_token(91);
                return 10;
            }
            case 92: {
                this.jj_consume_token(92);
                return -2;
            }
            case 93: {
                this.jj_consume_token(93);
                return -3;
            }
            case 94: {
                this.jj_consume_token(94);
                return 11;
            }
        }
        this.jj_la1[70] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int comparisonOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 76: {
                this.jj_consume_token(76);
                return 2;
            }
            case 79: {
                this.jj_consume_token(79);
                return 5;
            }
            case 74: {
                this.jj_consume_token(74);
                return 0;
            }
            case 75: {
                this.jj_consume_token(75);
                return 1;
            }
            case 77: {
                this.jj_consume_token(77);
                return 3;
            }
            case 78: {
                this.jj_consume_token(78);
                return 4;
            }
        }
        this.jj_la1[71] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_1();
        this.jj_save(0, xla);
        return retval;
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_2();
        this.jj_save(1, xla);
        return retval;
    }

    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_3();
        this.jj_save(2, xla);
        return retval;
    }

    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_4();
        this.jj_save(3, xla);
        return retval;
    }

    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_5();
        this.jj_save(4, xla);
        return retval;
    }

    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_6();
        this.jj_save(5, xla);
        return retval;
    }

    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_7();
        this.jj_save(6, xla);
        return retval;
    }

    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_8();
        this.jj_save(7, xla);
        return retval;
    }

    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_9();
        this.jj_save(8, xla);
        return retval;
    }

    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_10();
        this.jj_save(9, xla);
        return retval;
    }

    private final boolean jj_3R_98() {
        if (this.jj_scan_token(96)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_97() {
        if (this.jj_scan_token(95)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_96() {
        if (this.jj_scan_token(112)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_95() {
        if (this.jj_scan_token(102)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_107() {
        if (this.jj_3R_102()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_83() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_95()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_96()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_97()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_98()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_99()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_100() {
        if (this.jj_3R_106()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_91() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_84() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_100()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_101()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_80() {
        if (this.jj_3R_83()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_23() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_80()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_81()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_20() {
        if (this.jj_3R_22()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_9() {
        if (this.jj_3R_26()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_26() {
        if (this.jj_3R_84()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(106)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(107)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_4() {
        if (this.jj_3R_18()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_21()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_22()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(102)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_90() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_103() {
        if (this.jj_scan_token(106)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(107)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_93() {
        if (this.jj_3R_84()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_103()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_8() {
        if (this.jj_scan_token(108)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_25()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_6() {
        if (this.jj_scan_token(109)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_22()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_102() {
        Token xsp;
        block3: {
            if (this.jj_3R_22()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3_6()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_30() {
        if (this.jj_3R_93()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_19() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(38)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_29() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_21() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_29()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_30()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_89() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_3() {
        if (this.jj_3R_18()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_21()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_22()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(102)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_24() {
        if (this.jj_3R_82()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(110)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_3R_18()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_19()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_20()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(102)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_25() {
        if (this.jj_3R_83()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_88() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_7() {
        if (this.jj_3R_24()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_85() {
        if (this.jj_3R_102()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(109)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_27() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_85()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(38)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_87() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_86() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_28() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_86()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_87()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_88()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_89()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_90()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_91()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_92()) {
                                    return true;
                                }
                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_82() {
        if (this.jj_scan_token(95)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_18() {
        Token xsp;
        block1: {
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_28()) break block1;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_79() {
        if (this.jj_scan_token(94)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_78() {
        if (this.jj_scan_token(92)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_77() {
        if (this.jj_scan_token(91)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_76() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_75() {
        if (this.jj_scan_token(89)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_74() {
        if (this.jj_scan_token(88)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_73() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_72() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_71() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_70() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_69() {
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_68() {
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_67() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_66() {
        if (this.jj_scan_token(80)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_65() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_64() {
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_63() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_62() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_61() {
        if (this.jj_scan_token(75)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_60() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_59() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_58() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_57() {
        if (this.jj_scan_token(71)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_56() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_55() {
        if (this.jj_scan_token(69)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_54() {
        if (this.jj_scan_token(68)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_53() {
        if (this.jj_scan_token(66)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_52() {
        if (this.jj_scan_token(65)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_51() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_50() {
        if (this.jj_scan_token(62)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_49() {
        if (this.jj_scan_token(61)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_48() {
        if (this.jj_scan_token(60)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_47() {
        if (this.jj_scan_token(58)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_46() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_45() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_44() {
        if (this.jj_scan_token(55)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_43() {
        if (this.jj_scan_token(53)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_42() {
        if (this.jj_scan_token(50)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_41() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_40() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_39() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_10() {
        if (this.jj_3R_27()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_5() {
        if (this.jj_scan_token(108)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_23()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_38() {
        if (this.jj_scan_token(45)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_37() {
        if (this.jj_scan_token(44)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_36() {
        if (this.jj_scan_token(43)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_35() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_34() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_33() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_32() {
        if (this.jj_scan_token(39)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_31() {
        if (this.jj_scan_token(98)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_22() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_31()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_32()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_33()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_34()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_35()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_36()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_37()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_38()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_39()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_40()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_41()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_42()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_43()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_44()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_45()) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_3R_46()) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_3R_47()) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_3R_48()) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_3R_49()) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_3R_50()) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_3R_51()) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_3R_52()) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_3R_53()) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_3R_54()) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_3R_55()) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_3R_56()) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_3R_57()) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_3R_58()) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_3R_59()) {
                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                            if (this.jj_3R_60()) {
                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                if (this.jj_3R_61()) {
                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                    if (this.jj_3R_62()) {
                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                        if (this.jj_3R_63()) {
                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                            if (this.jj_3R_64()) {
                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                if (this.jj_3R_65()) {
                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                    if (this.jj_3R_66()) {
                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                        if (this.jj_3R_67()) {
                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                            if (this.jj_3R_68()) {
                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                if (this.jj_3R_69()) {
                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                    if (this.jj_3R_70()) {
                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                        if (this.jj_3R_71()) {
                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                            if (this.jj_3R_72()) {
                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                if (this.jj_3R_73()) {
                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                    if (this.jj_3R_74()) {
                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                        if (this.jj_3R_75()) {
                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                            if (this.jj_3R_76()) {
                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                if (this.jj_3R_77()) {
                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                    if (this.jj_3R_78()) {
                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                        if (this.jj_3R_79()) {
                                                                                                                                                                                                            return true;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                            return false;
                                                                                                                                                                                                        }
                                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                        return false;
                                                                                                                                                                                                    }
                                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                    return false;
                                                                                                                                                                                                }
                                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                                return false;
                                                                                                                                                                                            }
                                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                            return false;
                                                                                                                                                                                        }
                                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                        return false;
                                                                                                                                                                                    }
                                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                    return false;
                                                                                                                }
                                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                                return false;
                                                                                                            }
                                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                            return false;
                                                                                                        }
                                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                        return false;
                                                                                                    }
                                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                    return false;
                                                                                                }
                                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                                return false;
                                                                                            }
                                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                            return false;
                                                                                        }
                                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                        return false;
                                                                                    }
                                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                    return false;
                                                                                }
                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                return false;
                                                                            }
                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                            return false;
                                                                        }
                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                        return false;
                                                                    }
                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                    return false;
                                                                }
                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                return false;
                                                            }
                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                            return false;
                                                        }
                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                        return false;
                                                    }
                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                    return false;
                                                }
                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                return false;
                                            }
                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_3R_18()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(16)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_105() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_104() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_94() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_104()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_105()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_81() {
        if (this.jj_3R_94()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_113() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_112() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_111() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_110() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_111()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_112()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_113()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_109() {
        if (this.jj_3R_110()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_108() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_106() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_108()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_109()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_101() {
        if (this.jj_3R_107()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_92() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_99() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public Parser(InputStream stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 72; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 72; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Parser(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 72; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 72; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Parser(ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 72; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 72; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        return this.jj_scanpos.kind != kind;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] oldentry = (int[])enumeration.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public final ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[115];
        for (i = 0; i < 115; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 72; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((this.jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((this.jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((this.jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((this.jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 115; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, ParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 10; ++i) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                        break;
                    }
                    case 6: {
                        this.jj_3_7();
                        break;
                    }
                    case 7: {
                        this.jj_3_8();
                        break;
                    }
                    case 8: {
                        this.jj_3_9();
                        break;
                    }
                    case 9: {
                        this.jj_3_10();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

