/*
 * Decompiled with CFR 0.152.
 */
package carmel.parser;

import carmel.parser.LexOrParseException;
import carmel.parser.Token;

public class ParseException
extends LexOrParseException {
    protected static final String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token token, int[][] expectedTokens, String[] tokenImage) {
        super(ParseException.createErrorMessage(token.next, expectedTokens, tokenImage), token.next.beginLine, token.next.beginColumn);
    }

    protected static String createErrorMessage(Token token, int[][] expectedTokens, String[] tokenImage) {
        int index = ((int[][])expectedTokens).length;
        while (--index >= 0 && expectedTokens[index][0] != 98) {
        }
        if (index != -1) {
            int[][] newSequence = new int[((int[][])expectedTokens).length - 48][];
            System.arraycopy(expectedTokens, 0, newSequence, 0, index - 48);
            System.arraycopy(expectedTokens, index, newSequence, index - 48, newSequence.length - (index - 48));
            expectedTokens = newSequence;
        }
        StringBuffer expected = new StringBuffer("Was expecting");
        if (((int[][])expectedTokens).length != 1) {
            expected.append(" one of");
        }
        expected.append(':');
        int maxSize = 0;
        for (int i = 0; i < ((int[][])expectedTokens).length; ++i) {
            expected.append(eol).append('\t');
            if (maxSize < expectedTokens[i].length) {
                maxSize = expectedTokens[i].length;
            }
            for (int j = 0; j < expectedTokens[i].length; ++j) {
                expected.append(tokenImage[expectedTokens[i][j]]).append(' ');
            }
            if (expectedTokens[i][expectedTokens[i].length - 1] == 0) continue;
            expected.append("...");
        }
        StringBuffer message = new StringBuffer("Encountered \"");
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                message.append(' ');
            }
            if (token.kind == 0) {
                message.append(tokenImage[0]);
                break;
            }
            message.append(ParseException.add_escapes(token.image));
            token = token.next;
        }
        return message.append('\"').append(eol).append((Object)expected).toString();
    }

    public ParseException() {
        super(null, -1, -1);
        throw new Error();
    }

    public ParseException(String message, Token token) {
        super(message, token.beginLine, token.beginColumn);
    }

    protected static String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        block11: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    if (ch < ' ' || ch > '~') {
                        StringBuffer s = new StringBuffer(8).append("0000").append(Integer.toString(ch, 16));
                        retval.append("\\u").append(s.substring(s.length() - 4));
                        continue block11;
                    }
                    retval.append(ch);
                    continue block11;
                }
            }
        }
        return retval.toString();
    }
}

