/*
 * Decompiled with CFR 0.152.
 */
package carmel.interpreter;

import carmel.interpreter.CallStack;
import carmel.interpreter.CallStackEvent;
import carmel.interpreter.CallStackListener;
import carmel.interpreter.CarmelClassLoader;
import carmel.interpreter.CarmelException;
import carmel.interpreter.Heap;
import carmel.interpreter.PCEvent;
import carmel.interpreter.PCListener;
import carmel.interpreter.StackFrame;
import carmel.interpreter.StackFrameEvent;
import carmel.interpreter.StackFrameListener;
import carmel.interpreter.VMException;
import carmel.interpreter.VerificationException;
import carmel.interpreter.VirtualMachineListener;
import carmel.parser.LexOrParseException;
import carmel.tree.TreeClass;
import carmel.tree.TreeConstructor;
import carmel.tree.TreeMethod;
import carmel.type.TypeException;
import carmel.value.ClassValue;
import carmel.value.Value;
import java.util.Collections;
import javax.swing.event.EventListenerList;

public class VirtualMachine {
    public final ClassValue nullPointerException;
    public final ClassValue arithmeticException;
    public final ClassValue classCastException;
    public final ClassValue negativeArraySizeException;
    public final ClassValue arrayIndexOutOfBoundsException;
    public final ClassValue arrayStoreException;
    public final ClassValue securityException;
    protected Heap heap = new Heap();
    protected CallStack callStack = new CallStack();
    protected CarmelClassLoader classLoader;
    protected EventListenerList listeners = new EventListenerList();
    protected StepIntoListener stepIntoListener = new StepIntoListener();
    protected StepOverListener stepOverListener = new StepOverListener();
    protected StepOutListener stepOutListener = new StepOutListener();
    protected boolean wait = false;
    protected boolean halt = false;
    static Class class$carmel$interpreter$PCListener;
    static Class class$carmel$interpreter$VirtualMachineListener;

    public VirtualMachine() throws VMException, VerificationException, CarmelException, LexOrParseException, NoSuchMethodException, ClassNotFoundException {
        this.classLoader = new CarmelClassLoader(this.heap);
        this.nullPointerException = this.createInstance(this.loadClass("java.lang.NullPointerException"));
        this.arithmeticException = this.createInstance(this.loadClass("java.lang.ArithmeticException"));
        this.negativeArraySizeException = this.createInstance(this.loadClass("java.lang.NegativeArraySizeException"));
        this.classCastException = this.createInstance(this.loadClass("java.lang.ClassCastException"));
        this.arrayIndexOutOfBoundsException = this.createInstance(this.loadClass("java.lang.ArrayIndexOutOfBoundsException"));
        this.arrayStoreException = this.createInstance(this.loadClass("java.lang.ArrayStoreException"));
        this.securityException = this.createInstance(this.loadClass("java.lang.SecurityException"));
        this.callStack.addCallStackListener(new CallStackToPCListener());
    }

    private TreeClass loadClass(String name) throws LexOrParseException, ClassNotFoundException {
        try {
            TreeClass treeClass = (TreeClass)this.classLoader.loadClass(name);
            return treeClass;
        }
        catch (ClassCastException e) {
            throw new ClassNotFoundException(String.valueOf(String.valueOf(name)).concat(" must not be an interface"));
        }
    }

    protected ClassValue createInstance(TreeClass c) throws VMException, VerificationException, CarmelException, NoSuchMethodException {
        ClassValue value = new ClassValue(this.heap, c);
        try {
            new StackFrame(this, c.getDefaultConstructor(), Collections.EMPTY_LIST, value).interpret();
        }
        catch (HaltException e) {
            throw new VMException("Unexpected halt exception", e);
        }
        return value;
    }

    public void invokeInstanceMethod(TreeMethod method, ClassValue value) throws IllegalArgumentException {
        if (method.isStatic()) {
            throw new IllegalArgumentException("Method must not be static");
        }
        if (!(method.getParentClass() instanceof TreeClass)) {
            throw new IllegalArgumentException("Cannot invoke an interface method");
        }
        if (!method.getParameterTypes().isEmpty()) {
            throw new IllegalArgumentException("Method must not take any parameters");
        }
        this.callStack.clear();
        try {
            this.interpretFrame(new StackFrame(this, method, Collections.EMPTY_LIST, value));
        }
        catch (TypeException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void invokeStaticMethod(TreeMethod method) throws IllegalArgumentException {
        if (!method.isStatic()) {
            throw new IllegalArgumentException("Method must be static");
        }
        if (!(method.getParentClass() instanceof TreeClass)) {
            throw new IllegalArgumentException("Cannot invoke an interface method");
        }
        if (!method.getParameterTypes().isEmpty()) {
            throw new IllegalArgumentException("Method must not take any parameters");
        }
        this.callStack.clear();
        this.interpretFrame(new StackFrame(this, method, Collections.EMPTY_LIST));
    }

    public void invokeConstructor(TreeConstructor c) throws IllegalArgumentException {
        if (!c.getParameterTypes().isEmpty()) {
            throw new IllegalArgumentException("Constructor must not take any parameters");
        }
        this.callStack.clear();
        try {
            this.interpretFrame(new StackFrame(this, c, Collections.EMPTY_LIST, new ClassValue(this.heap, (TreeClass)c.getParentClass())));
        }
        catch (TypeException e) {
            throw new Error("Unexpected TypeException");
        }
    }

    protected void interpretFrame(final StackFrame frame) {
        this.halt = false;
        this.wait = true;
        new Thread(new Runnable(){

            public void run() {
                try {
                    VirtualMachine.this.fireMethodReturned(frame.interpret());
                }
                catch (HaltException e) {
                    VirtualMachine.this.callStack.clear();
                    VirtualMachine.this.fireVMHalted();
                }
                catch (CarmelException e) {
                    VirtualMachine.this.callStack.setStack(e.getCallStack());
                    VirtualMachine.this.fireMethodReturned(e);
                }
                catch (VerificationException e) {
                    VirtualMachine.this.fireVMException(e);
                }
                catch (VMException e) {
                    VirtualMachine.this.fireVMException((Exception)e.getCause());
                }
            }
        }).start();
    }

    public Heap getHeap() {
        return this.heap;
    }

    public CarmelClassLoader getClassLoader() {
        return this.classLoader;
    }

    public CallStack getCallStack() {
        return this.callStack;
    }

    public void addPCListener(PCListener l) {
        this.listeners.add(class$carmel$interpreter$PCListener == null ? (class$carmel$interpreter$PCListener = VirtualMachine.class$("carmel.interpreter.PCListener")) : class$carmel$interpreter$PCListener, l);
    }

    public void removePCListener(PCListener l) {
        this.listeners.remove(class$carmel$interpreter$PCListener == null ? (class$carmel$interpreter$PCListener = VirtualMachine.class$("carmel.interpreter.PCListener")) : class$carmel$interpreter$PCListener, l);
    }

    public void addVMListener(VirtualMachineListener l) {
        this.listeners.add(class$carmel$interpreter$VirtualMachineListener == null ? (class$carmel$interpreter$VirtualMachineListener = VirtualMachine.class$("carmel.interpreter.VirtualMachineListener")) : class$carmel$interpreter$VirtualMachineListener, l);
    }

    public void removeVMListener(VirtualMachineListener l) {
        this.listeners.remove(class$carmel$interpreter$VirtualMachineListener == null ? (class$carmel$interpreter$VirtualMachineListener = VirtualMachine.class$("carmel.interpreter.VirtualMachineListener")) : class$carmel$interpreter$VirtualMachineListener, l);
    }

    protected void resume() {
        if (this.wait) {
            this.wait = false;
            this.notify();
        }
    }

    public synchronized void run() {
        this.resume();
    }

    public synchronized void halt() {
        this.halt = true;
        this.notify();
    }

    public synchronized void stepInto() {
        this.resume();
        this.addPCListener(this.stepIntoListener);
    }

    public synchronized void stepOver() {
        this.resume();
        this.callStack.peek().addStackFrameListener(this.stepOverListener);
    }

    public synchronized void stepOut() {
        this.resume();
        this.callStack.peek().addStackFrameListener(this.stepOutListener);
    }

    protected synchronized void waitForNextInstruction() throws HaltException {
        if (this.halt) {
            throw new HaltException(this);
        }
        while (this.wait) {
            try {
                this.wait();
                if (!this.halt) continue;
                throw new HaltException(this);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    protected void fireMethodReturned(Value v) {
        Object[] list = this.listeners.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$carmel$interpreter$VirtualMachineListener == null ? VirtualMachine.class$("carmel.interpreter.VirtualMachineListener") : class$carmel$interpreter$VirtualMachineListener)) continue;
            ((VirtualMachineListener)list[i + 1]).methodReturned(v);
        }
    }

    protected void fireMethodReturned(CarmelException e) {
        Object[] list = this.listeners.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$carmel$interpreter$VirtualMachineListener == null ? VirtualMachine.class$("carmel.interpreter.VirtualMachineListener") : class$carmel$interpreter$VirtualMachineListener)) continue;
            ((VirtualMachineListener)list[i + 1]).methodReturned(e);
        }
    }

    protected void fireVMException(VerificationException e) {
        Object[] list = this.listeners.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$carmel$interpreter$VirtualMachineListener == null ? VirtualMachine.class$("carmel.interpreter.VirtualMachineListener") : class$carmel$interpreter$VirtualMachineListener)) continue;
            ((VirtualMachineListener)list[i + 1]).vmException(e);
        }
    }

    protected void fireVMException(Exception e) {
        Object[] list = this.listeners.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$carmel$interpreter$VirtualMachineListener == null ? VirtualMachine.class$("carmel.interpreter.VirtualMachineListener") : class$carmel$interpreter$VirtualMachineListener)) continue;
            ((VirtualMachineListener)list[i + 1]).vmException(e);
        }
    }

    protected void fireVMHalted() {
        Object[] list = this.listeners.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$carmel$interpreter$VirtualMachineListener == null ? VirtualMachine.class$("carmel.interpreter.VirtualMachineListener") : class$carmel$interpreter$VirtualMachineListener)) continue;
            ((VirtualMachineListener)list[i + 1]).vmHalted();
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    protected class StepOutListener
    implements StackFrameListener {
        protected StepOutListener() {
        }

        public void pcChanged(StackFrameEvent e) {
        }

        public void framePopped(StackFrameEvent e) {
            ((StackFrame)e.getSource()).removeStackFrameListener(this);
            VirtualMachine.this.wait = true;
        }
    }

    protected class StepOverListener
    extends StepOutListener {
        protected StepOverListener() {
        }

        public void pcChanged(StackFrameEvent e) {
            ((StackFrame)e.getSource()).removeStackFrameListener(this);
            VirtualMachine.this.wait = true;
        }
    }

    protected class StepIntoListener
    implements PCListener {
        protected StepIntoListener() {
        }

        public void pcChanged(PCEvent e) {
            ((VirtualMachine)e.getSource()).removePCListener(this);
            VirtualMachine.this.wait = true;
        }
    }

    protected class CallStackToPCListener
    implements CallStackListener,
    StackFrameListener {
        protected CallStackToPCListener() {
        }

        public void framePushed(CallStackEvent e) {
            e.getFrame().addStackFrameListener(this);
        }

        public void framePopped(CallStackEvent e) {
            e.getFrame().removeStackFrameListener(this);
        }

        public void pcChanged(StackFrameEvent e) {
            PCEvent pcEvent = new PCEvent(VirtualMachine.this, (StackFrame)e.getSource(), e.getPC());
            Object[] list = VirtualMachine.this.listeners.getListenerList();
            for (int i = list.length - 2; i >= 0; i -= 2) {
                if (list[i] != (class$carmel$interpreter$PCListener == null ? VirtualMachine.class$("carmel.interpreter.PCListener") : class$carmel$interpreter$PCListener)) continue;
                ((PCListener)list[i + 1]).pcChanged(pcEvent);
            }
        }

        public void framePopped(StackFrameEvent e) {
        }
    }

    protected class HaltException
    extends Exception {
        protected HaltException(VirtualMachine this$0) {
        }
    }
}

