/*
 * Decompiled with CFR 0.152.
 */
package carmel.interpreter;

import carmel.interpreter.CarmelSource;
import carmel.interpreter.FileCarmelSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;

public class URLCarmelSource
extends CarmelSource {
    protected URL url;

    public URLCarmelSource(URL url) throws IOException {
        super(url.getFile().substring(url.getFile().lastIndexOf(47) + 1), url.openConnection().getContentLength());
        this.url = url;
    }

    public Reader openReader() throws IOException {
        return new InputStreamReader(this.url.openStream());
    }

    public static CarmelSource createCarmelSource(URL url) throws IOException {
        if ("file".equals(url.getProtocol())) {
            try {
                FileCarmelSource fileCarmelSource = new FileCarmelSource(new File(URLCarmelSource.removeURLEscapes(url.getFile())));
                return fileCarmelSource;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return new URLCarmelSource(url);
    }

    public static String removeURLEscapes(String file) {
        char[] oldChars = file.toCharArray();
        int oldLength = oldChars.length;
        char[] newChars = new char[oldLength];
        int startIndex = 0;
        int index = 0;
        int newLength = 0;
        while (true) {
            if ((index = file.indexOf(37, startIndex)) == -1) {
                index = oldLength;
            }
            int count = index - startIndex;
            System.arraycopy(oldChars, startIndex, newChars, newLength, count);
            newLength += count;
            if (index == oldLength) break;
            try {
                try {
                    newChars[newLength] = (char)Short.parseShort(file.substring(index + 1, index + 3), 16);
                    ++newLength;
                }
                catch (NumberFormatException e) {
                    System.arraycopy(oldChars, index, newChars, newLength, 3);
                    newLength += 3;
                }
            }
            catch (IndexOutOfBoundsException e) {
                count = oldLength - index;
                System.arraycopy(oldChars, index, newChars, newLength, count);
                newLength += count;
                break;
            }
            startIndex = index + 3;
        }
        return new String(newChars, 0, newLength);
    }
}

