/*
 * Decompiled with CFR 0.152.
 */
package carmel.interpreter;

import carmel.interpreter.CarmelException;
import carmel.interpreter.CarmelSource;
import carmel.interpreter.LocalVariableArray;
import carmel.interpreter.OperandStack;
import carmel.interpreter.ProgramCounter;
import carmel.interpreter.StackFrameEvent;
import carmel.interpreter.StackFrameListener;
import carmel.interpreter.VMException;
import carmel.interpreter.VerificationException;
import carmel.interpreter.VirtualMachine;
import carmel.tree.ArrayLengthInstruction;
import carmel.tree.ArrayLoadInstruction;
import carmel.tree.ArrayStoreInstruction;
import carmel.tree.CheckCastInstruction;
import carmel.tree.DupInstruction;
import carmel.tree.ExceptionHandler;
import carmel.tree.GetFieldInstruction;
import carmel.tree.GetStaticInstruction;
import carmel.tree.GotoInstruction;
import carmel.tree.IfInstruction;
import carmel.tree.IncInstruction;
import carmel.tree.InstanceOfInstruction;
import carmel.tree.Instruction;
import carmel.tree.InstructionVisitor;
import carmel.tree.InvokeConstructorInstruction;
import carmel.tree.InvokeDefiniteMethodInstruction;
import carmel.tree.InvokeInterfaceInstruction;
import carmel.tree.InvokeVirtualInstruction;
import carmel.tree.JsrInstruction;
import carmel.tree.LoadInstruction;
import carmel.tree.LookupSwitchInstruction;
import carmel.tree.NewArrayInstruction;
import carmel.tree.NewClassInstruction;
import carmel.tree.NopInstruction;
import carmel.tree.NumOpInstruction;
import carmel.tree.PopInstruction;
import carmel.tree.PushInstruction;
import carmel.tree.PutFieldInstruction;
import carmel.tree.PutStaticInstruction;
import carmel.tree.RetInstruction;
import carmel.tree.ReturnInstruction;
import carmel.tree.StoreInstruction;
import carmel.tree.SwapInstruction;
import carmel.tree.TableSwitchInstruction;
import carmel.tree.ThrowInstruction;
import carmel.tree.TreeClass;
import carmel.tree.TreeConstructor;
import carmel.tree.TreeConstructorOrMethod;
import carmel.tree.TreeMethod;
import carmel.type.JCVMIntType;
import carmel.type.JCVMReferenceType;
import carmel.type.JCVMReturnAddressType;
import carmel.type.NullType;
import carmel.type.ResultType;
import carmel.type.Type;
import carmel.type.TypeException;
import carmel.type.VoidType;
import carmel.value.ArrayValue;
import carmel.value.ClassValue;
import carmel.value.IntValue;
import carmel.value.NumericValue;
import carmel.value.ReferenceValue;
import carmel.value.ShortValue;
import carmel.value.StackEntry;
import carmel.value.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;

public class StackFrame {
    protected VirtualMachine vm;
    protected TreeConstructorOrMethod method;
    protected ProgramCounter pc;
    protected LocalVariableArray localVariables;
    protected OperandStack operandStack = new OperandStack();
    protected InterpreterVisitor interpreter = new InterpreterVisitor();
    protected boolean isConstructor = false;
    protected EventListenerList listeners = new EventListenerList();
    static Class class$carmel$interpreter$StackFrameListener;

    protected StackFrame(VirtualMachine vm, TreeConstructorOrMethod method) throws IllegalArgumentException {
        if (method.isAbstract()) {
            throw new IllegalArgumentException("Attempt to invoke an abstract method");
        }
        if (method.isNative()) {
            throw new IllegalArgumentException("Attempt to interpret a native method");
        }
        this.vm = vm;
        this.method = method;
        this.pc = method.instructionBlock.firstInstruction;
    }

    public StackFrame(VirtualMachine vm, TreeMethod method, List parameters) throws IllegalArgumentException {
        this(vm, method);
        if (!method.isStatic()) {
            throw new IllegalArgumentException("Attempt to invoke an instance method without a class value");
        }
        this.localVariables = new LocalVariableArray(method.localVariableArraySize, parameters);
    }

    protected StackFrame(VirtualMachine vm, TreeConstructorOrMethod method, List parameters, ClassValue classValue) throws IllegalArgumentException, TypeException {
        this(vm, method);
        method.parentClass.checkAssignableFrom(classValue.getType());
        this.localVariables = new LocalVariableArray(method.localVariableArraySize, classValue, parameters);
    }

    public StackFrame(VirtualMachine vm, TreeConstructor method, List parameters, ClassValue classValue) throws IllegalArgumentException, TypeException {
        this(vm, (TreeConstructorOrMethod)method, parameters, classValue);
        this.isConstructor = true;
    }

    public StackFrame(VirtualMachine vm, TreeMethod method, List parameters, ClassValue classValue) throws IllegalArgumentException, TypeException {
        this(vm, (TreeConstructorOrMethod)method, parameters, classValue);
        if (method.isStatic()) {
            throw new IllegalArgumentException("Attempt to invoke a static method with a class value");
        }
    }

    public TreeConstructorOrMethod getMethod() {
        return this.method;
    }

    public ProgramCounter getPC() {
        return this.pc;
    }

    public CarmelSource getCarmelSource() {
        return this.method.parentClass.parentPackage.source;
    }

    public OperandStack getOperandStack() {
        return this.operandStack;
    }

    public LocalVariableArray getLocalVariables() {
        return this.localVariables;
    }

    public void addStackFrameListener(StackFrameListener l) {
        this.listeners.add(class$carmel$interpreter$StackFrameListener == null ? (class$carmel$interpreter$StackFrameListener = StackFrame.class$("carmel.interpreter.StackFrameListener")) : class$carmel$interpreter$StackFrameListener, l);
    }

    public void removeStackFrameListener(StackFrameListener l) {
        this.listeners.remove(class$carmel$interpreter$StackFrameListener == null ? (class$carmel$interpreter$StackFrameListener = StackFrame.class$("carmel.interpreter.StackFrameListener")) : class$carmel$interpreter$StackFrameListener, l);
    }

    protected void firePCChanged() {
        StackFrameEvent e = new StackFrameEvent(this, this.pc);
        Object[] list = this.listeners.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$carmel$interpreter$StackFrameListener == null ? StackFrame.class$("carmel.interpreter.StackFrameListener") : class$carmel$interpreter$StackFrameListener)) continue;
            ((StackFrameListener)list[i + 1]).pcChanged(e);
        }
    }

    protected void fireFramePopped() {
        StackFrameEvent e = new StackFrameEvent(this);
        Object[] list = this.listeners.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$carmel$interpreter$StackFrameListener == null ? StackFrame.class$("carmel.interpreter.StackFrameListener") : class$carmel$interpreter$StackFrameListener)) continue;
            ((StackFrameListener)list[i + 1]).framePopped(e);
        }
    }

    public Value interpret() throws VirtualMachine.HaltException, VMException, VerificationException, CarmelException {
        this.vm.callStack.push(this);
        try {
            block10: while (true) {
                try {
                    while (true) {
                        this.firePCChanged();
                        this.vm.waitForNextInstruction();
                        this.operandStack.restorePointStart();
                        ((Instruction)this.pc).visit(this.interpreter);
                        this.pc = this.pc.getNextPC();
                    }
                }
                catch (InterpreterVisitor.JumpException e) {
                    this.pc = e.instruction;
                }
                catch (CarmelException e) {
                    this.operandStack.restore();
                    TreeClass exceptionType = (TreeClass)e.getException().getType();
                    int index = ((Instruction)this.pc).blockIndex;
                    Iterator i = this.method.instructionBlock.handlers.iterator();
                    while (i.hasNext()) {
                        ExceptionHandler h = (ExceptionHandler)i.next();
                        if (h.fromIndex > index || index > h.toIndex || h.catchType != null && !h.catchType.isAssignableFrom(exceptionType)) continue;
                        this.pc = h;
                        this.firePCChanged();
                        this.vm.waitForNextInstruction();
                        this.operandStack.clear();
                        this.operandStack.push(e.getException());
                        this.pc = this.pc.getNextPC();
                        continue block10;
                    }
                    if (this.vm.classLoader.runtimeException.isAssignableFrom(exceptionType)) {
                        throw e;
                    }
                    i = this.method.getExceptionTypes().iterator();
                    while (i.hasNext()) {
                        if (!((TreeClass)i.next()).isAssignableFrom(exceptionType)) continue;
                        throw e;
                    }
                    throw new VerificationException(String.valueOf(String.valueOf(exceptionType.getName())).concat(" must be caught or declared to be thrown"));
                }
                break;
            }
        }
        catch (CarmelException e) {
            e.addFrame(this);
            this.vm.callStack.pop();
            this.fireFramePopped();
            throw e;
        }
        catch (VerificationException e) {
            this.operandStack.restore();
            throw e;
        }
        catch (InterpreterVisitor.ReturnException e) {
            this.vm.callStack.pop();
            this.fireFramePopped();
            Value value = e.getValue();
            return value;
        }
        catch (VirtualMachine.HaltException e) {
            throw e;
        }
        catch (VMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VMException("Exception encountered during intepreting", e);
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    protected class InterpreterVisitor
    implements InstructionVisitor {
        protected InterpreterVisitor() {
        }

        public void visit(NopInstruction i) throws Exception {
        }

        public void visit(PushInstruction i) throws Exception {
            StackFrame.this.operandStack.push(i.constant);
        }

        public void visit(PopInstruction i) throws Exception {
            StackFrame.this.operandStack.popWords(i.count);
        }

        public void visit(DupInstruction i) throws Exception {
            StackFrame.this.operandStack.dupWords(i.count, i.depth);
        }

        public void visit(SwapInstruction i) throws Exception {
            StackFrame.this.operandStack.swapWords(i.top, i.following);
        }

        public void visit(NumOpInstruction i) throws Exception {
            if (i.isUnary()) {
                StackFrame.this.operandStack.push(i.operandType.applyUnaryNumOp(i.operator, StackFrame.this.operandStack.popNumericValue(i.operandType), i.resultType));
            } else {
                NumericValue v2 = StackFrame.this.operandStack.popNumericValue(i.operandType);
                NumericValue v1 = StackFrame.this.operandStack.popNumericValue(i.operandType);
                try {
                    StackFrame.this.operandStack.push(i.operandType.applyBinaryNumOp(i.operator, v1, v2));
                }
                catch (ArithmeticException e) {
                    throw new CarmelException(StackFrame.this.vm.arithmeticException);
                }
            }
        }

        public void visit(LoadInstruction i) throws Exception {
            StackFrame.this.operandStack.push(StackFrame.this.localVariables.get(i.index, i.type));
        }

        public void visit(StoreInstruction i) throws Exception {
            StackFrame.this.localVariables.set(i.index, StackFrame.this.operandStack.pop(i.type));
        }

        public void visit(IncInstruction i) throws Exception {
            StackFrame.this.localVariables.set(i.index, i.type.applyBinaryNumOp(0, (NumericValue)StackFrame.this.localVariables.get(i.index, i.type), i.value));
        }

        public void visit(GotoInstruction i) throws Exception {
            throw new JumpException(this, i.instruction);
        }

        public void visit(IfInstruction i) throws Exception {
            Value v2 = i.value == null ? StackFrame.this.operandStack.popValue(i.type) : i.value;
            Value v1 = StackFrame.this.operandStack.popValue(i.type);
            if (i.type.applyCondOp(i.operator, v1, v2)) {
                throw new JumpException(this, i.instruction);
            }
        }

        public void visit(LookupSwitchInstruction i) throws Exception {
            Instruction instruction = (Instruction)i.switches.get(StackFrame.this.operandStack.popNumericValue(i.type));
            throw new JumpException(this, instruction == null ? i.instruction : instruction);
        }

        public void visit(TableSwitchInstruction i) throws Exception {
            try {
                throw new JumpException(this, (Instruction)i.addresses.get(((IntValue)i.type.applyUnaryNumOp(-2, StackFrame.this.operandStack.popNumericValue(i.type), JCVMIntType.TYPE)).getValue() - i.value));
            }
            catch (IndexOutOfBoundsException e) {
                throw new JumpException(this, i.instruction);
            }
        }

        public void visit(NewArrayInstruction i) throws Exception {
            try {
                StackFrame.this.operandStack.push(new ArrayValue(StackFrame.this.vm.heap, i.type, StackFrame.this.operandStack.popShort().getValue()));
            }
            catch (NegativeArraySizeException e) {
                throw new CarmelException(StackFrame.this.vm.negativeArraySizeException);
            }
        }

        public void visit(NewClassInstruction i) throws Exception {
            StackFrame.this.operandStack.push(new ClassValue(StackFrame.this.vm.heap, i.classType));
        }

        public void visit(CheckCastInstruction i) throws Exception {
            i.type.checkAssignableFrom(((ReferenceValue)StackFrame.this.operandStack.peek(JCVMReferenceType.TYPE)).getType());
        }

        public void visit(InstanceOfInstruction i) throws Exception {
            StackFrame.this.operandStack.push(new ShortValue((short)(i.type.isAssignableFrom(StackFrame.this.operandStack.popReference().getType()) ? 1 : 0)));
        }

        public void visit(GetStaticInstruction i) throws Exception {
            StackFrame.this.operandStack.push(i.field.getValue());
        }

        public void visit(PutStaticInstruction i) throws Exception {
            i.field.setValue(StackFrame.this.operandStack.popValue(i.field.getType().getJCVMType()));
        }

        public void visit(GetFieldInstruction i) throws Exception {
            ClassValue c = i.thisField ? (ClassValue)StackFrame.this.localVariables.get(0) : this.popClassValue();
            StackFrame.this.operandStack.push(i.field.getValue(c));
        }

        public void visit(PutFieldInstruction i) throws Exception {
            ClassValue c = i.thisField ? (ClassValue)StackFrame.this.localVariables.get(0) : this.popClassValue();
            i.field.setValue(c, StackFrame.this.operandStack.popValue(i.field.getType().getJCVMType()));
        }

        protected ArrayValue popArrayValue() throws CarmelException, TypeException, VerificationException {
            ReferenceValue o = StackFrame.this.operandStack.popReference();
            this.checkNull(o);
            if (!(o instanceof ArrayValue)) {
                throw new TypeException(String.valueOf(String.valueOf(new StringBuffer("Array value expected, value of type ").append(o.getType().getName()).append(" found"))));
            }
            return (ArrayValue)o;
        }

        protected ClassValue popClassValue() throws CarmelException, TypeException, VerificationException {
            ReferenceValue o = StackFrame.this.operandStack.popReference();
            this.checkNull(o);
            StackFrame.this.vm.classLoader.object.checkAssignableFrom(o.getType());
            return (ClassValue)o;
        }

        protected List popMethodParameters(List parameterTypes) throws TypeException, VerificationException {
            Value[] parameters = new Value[parameterTypes.size()];
            int index = parameters.length;
            while (--index >= 0) {
                Value value;
                Type parameterType = (Type)parameterTypes.get(index);
                if (!parameterType.isAssignableFrom((value = StackFrame.this.operandStack.popValue(parameterType.getJCVMType())).getType())) {
                    throw new TypeException(String.valueOf(String.valueOf(new StringBuffer("Parameter ").append(index).append(" is of type ").append(parameterType.getName()).append(", found incompatible type ").append(value.getType().getName()))));
                }
                parameters[index] = value;
            }
            return new ArrayList<Value>(Arrays.asList(parameters));
        }

        protected void invokeMethod(TreeMethod method, List parameters, ClassValue classValue) throws Exception {
            ResultType type;
            Value v;
            if (method.isStatic()) {
                if (method.isNative()) {
                    throw new VMException("Native methods not yet implemented", new Exception());
                }
                v = new StackFrame(StackFrame.this.vm, method, parameters).interpret();
            } else {
                if (!(classValue.isInit || !StackFrame.this.isConstructor || classValue == StackFrame.this.localVariables.get(0) && method.getParentClass().isAssignableFrom(classValue.getType()))) {
                    throw new VerificationException("Attempt to invoke a method on an object that has not been initialised");
                }
                if (method.isNative()) {
                    throw new VMException("Native methods not yet implemented", new Exception());
                }
                v = new StackFrame(StackFrame.this.vm, method, parameters, classValue).interpret();
            }
            ResultType resultType = type = v == null ? VoidType.TYPE : v.getType();
            if (!method.getResultType().isAssignableFrom(type)) {
                throw new VerificationException(String.valueOf(String.valueOf(new StringBuffer("Method declared to return type ").append(method.getResultType().getName()).append(" but has returned a value of type ").append(type.getName()))));
            }
            if (v != null) {
                StackFrame.this.operandStack.push(v);
            }
        }

        public void visit(InvokeConstructorInstruction i) throws Exception {
            List parameters = this.popMethodParameters(i.constructor.getParameterTypes());
            ClassValue classValue = this.popClassValue();
            if (classValue.isInit) {
                throw new VerificationException("Attempt to call constructor for a second time");
            }
            if (new StackFrame(StackFrame.this.vm, i.constructor, parameters, classValue).interpret() != null) {
                throw new VerificationException("Constructor cannot return a value");
            }
            if (!StackFrame.this.isConstructor || classValue != StackFrame.this.localVariables.get(0)) {
                classValue.isInit = true;
            }
        }

        public void visit(InvokeDefiniteMethodInstruction i) throws Exception {
            List parameters = this.popMethodParameters(i.method.getParameterTypes());
            if (i.method.isStatic()) {
                this.invokeMethod(i.method, parameters, null);
            } else {
                this.invokeMethod(i.method, parameters, this.popClassValue());
            }
        }

        public void visit(InvokeVirtualInstruction i) throws Exception {
            List parameters = this.popMethodParameters(i.methodID.types);
            ClassValue v = this.popClassValue();
            TreeClass type = (TreeClass)v.getType();
            try {
                this.invokeMethod(type.getMethod(i.methodID), parameters, v);
            }
            catch (NoSuchMethodException e) {
                throw new VerificationException(e.getMessage());
            }
        }

        public void visit(InvokeInterfaceInstruction i) throws Exception {
            List parameters = this.popMethodParameters(i.methodID.types);
            ClassValue v = this.popClassValue();
            TreeClass type = (TreeClass)v.getType();
            i.parentInterface.checkAssignableFrom(type);
            try {
                this.invokeMethod(type.getMethod(i.methodID), parameters, v);
            }
            catch (NoSuchMethodException e) {
                throw new VerificationException(e.getMessage());
            }
        }

        public void visit(ReturnInstruction i) throws Exception {
            if (i.type == null) {
                throw new ReturnException(this);
            }
            Value v = StackFrame.this.operandStack.popValue(i.type);
            ((TreeMethod)StackFrame.this.method).getResultType().checkAssignableFrom(v.getType());
            throw new ReturnException(this, v);
        }

        public void visit(ArrayLengthInstruction i) throws Exception {
            StackFrame.this.operandStack.push(new ShortValue(this.popArrayValue().getLength()));
        }

        public void visit(ArrayLoadInstruction i) throws Exception {
            short index = StackFrame.this.operandStack.popShort().getValue();
            try {
                StackFrame.this.operandStack.push(this.popArrayValue().getValueAt(index));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new CarmelException(StackFrame.this.vm.arrayIndexOutOfBoundsException);
            }
        }

        public void visit(ArrayStoreInstruction i) throws Exception {
            StackEntry v = StackFrame.this.operandStack.pop();
            short index = StackFrame.this.operandStack.popShort().getValue();
            ArrayValue a = this.popArrayValue();
            a.getComponentType().getJCVMType().checkType(v);
            try {
                a.setValueAt(index, (Value)v);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new CarmelException(StackFrame.this.vm.arrayIndexOutOfBoundsException);
            }
        }

        public void visit(ThrowInstruction i) throws Exception {
            ClassValue c = this.popClassValue();
            StackFrame.this.vm.classLoader.throwable.checkAssignableFrom(c.getType());
            throw new CarmelException(c);
        }

        public void visit(JsrInstruction i) throws Exception {
            StackFrame.this.operandStack.push(i.next);
            throw new JumpException(this, i.instruction);
        }

        public void visit(RetInstruction i) throws Exception {
            throw new JumpException(this, (Instruction)StackFrame.this.localVariables.get(i.index, JCVMReturnAddressType.TYPE));
        }

        protected void checkNull(ReferenceValue v) throws CarmelException {
            if (v.getType() == NullType.TYPE) {
                throw new CarmelException(StackFrame.this.vm.nullPointerException);
            }
        }

        protected class ReturnException
        extends Exception {
            Value value = null;

            ReturnException(InterpreterVisitor this$1) {
            }

            ReturnException(InterpreterVisitor this$1, Value value) {
                this.value = value;
            }

            Value getValue() {
                return this.value;
            }
        }

        protected class JumpException
        extends Exception {
            Instruction instruction;

            JumpException(InterpreterVisitor this$1, Instruction instruction) {
                this.instruction = instruction;
            }
        }
    }
}

