/*
 * Decompiled with CFR 0.152.
 */
package carmel.interpreter;

import carmel.interpreter.OperandStackEvent;
import carmel.interpreter.OperandStackListener;
import carmel.interpreter.StackEntryList;
import carmel.interpreter.StackEntryListListener;
import carmel.interpreter.VerificationException;
import carmel.type.JCVMByteType;
import carmel.type.JCVMNumericType;
import carmel.type.JCVMOperandType;
import carmel.type.JCVMReferenceType;
import carmel.type.JCVMShortType;
import carmel.type.JCVMType;
import carmel.type.TypeException;
import carmel.value.BottomValue;
import carmel.value.ByteValue;
import carmel.value.NumericValue;
import carmel.value.ReferenceValue;
import carmel.value.ShortValue;
import carmel.value.StackEntry;
import carmel.value.Value;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.event.EventListenerList;

public class OperandStack
implements StackEntryList {
    protected LinkedList list = new LinkedList();
    protected LinkedList restoreList = new LinkedList();
    protected EventListenerList listeners = new EventListenerList();
    protected boolean restore = false;
    static Class class$carmel$interpreter$OperandStackListener;

    public void push(StackEntry o) throws NullPointerException {
        this.restore = false;
        if (o == null) {
            throw new NullPointerException("Null is not a valid stack value");
        }
        JCVMType type = o.getJCVMType();
        if (type == JCVMByteType.TYPE) {
            this.list.addFirst(((ByteValue)o).toShort());
            this.fireEntriesPushed(1);
        } else if (type.isDoubleWord()) {
            this.list.addFirst(BottomValue.BOTTOM);
            this.list.addFirst(o);
            this.fireEntriesPushed(2);
        } else {
            this.list.addFirst(o);
            this.fireEntriesPushed(1);
        }
    }

    public StackEntry pop() throws VerificationException {
        try {
            StackEntry o = (StackEntry)this.list.removeFirst();
            if (this.restore) {
                this.restoreList.add(o);
            }
            if (!this.list.isEmpty() && this.list.getFirst() == BottomValue.BOTTOM) {
                if (this.restore) {
                    this.restoreList.add(BottomValue.BOTTOM);
                }
                this.list.removeFirst();
                this.fireEntriesPopped(2);
            } else {
                this.fireEntriesPopped(1);
            }
            StackEntry stackEntry = o;
            return stackEntry;
        }
        catch (NoSuchElementException e) {
            throw new VerificationException("Attempt to pop a value from an empty operand stack");
        }
    }

    public StackEntry pop(JCVMType type) throws VerificationException, TypeException {
        if (type == JCVMByteType.TYPE) {
            return ByteValue.fromShort((ShortValue)this.pop(JCVMShortType.TYPE));
        }
        StackEntry o = this.pop();
        type.checkType(o);
        return o;
    }

    public Value popValue(JCVMOperandType type) throws VerificationException, TypeException {
        return (Value)this.pop(type);
    }

    public NumericValue popNumericValue(JCVMNumericType type) throws VerificationException, TypeException {
        return (NumericValue)this.pop(type);
    }

    public ReferenceValue popReference() throws VerificationException, TypeException {
        return (ReferenceValue)this.pop(JCVMReferenceType.TYPE);
    }

    public ShortValue popShort() throws VerificationException, TypeException {
        return (ShortValue)this.pop(JCVMShortType.TYPE);
    }

    public StackEntry peek() throws VerificationException {
        try {
            StackEntry stackEntry = (StackEntry)this.list.getFirst();
            return stackEntry;
        }
        catch (NoSuchElementException e) {
            throw new VerificationException("Attempt to peek at a value on an empty operand stack");
        }
    }

    public StackEntry peek(JCVMType type) throws VerificationException, TypeException {
        if (JCVMByteType.TYPE.equals(type)) {
            return ByteValue.fromShort((ShortValue)this.peek(JCVMShortType.TYPE));
        }
        StackEntry o = this.peek();
        type.checkType(o);
        return o;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void clear() {
        this.list.clear();
    }

    public int getSizeInWords() {
        return this.list.size();
    }

    public void popWords(int numWords) throws VerificationException {
        if (numWords == 0) {
            return;
        }
        this.checkLastIndex(numWords);
        this.restore = false;
        this.list.subList(0, numWords).clear();
        this.fireEntriesPopped(numWords);
    }

    public void dupWords(int numWords, int depth) throws VerificationException {
        if (numWords == 0) {
            return;
        }
        this.checkLastIndex(numWords);
        this.restore = false;
        List subList = this.list.subList(0, numWords);
        this.list.addAll(depth, new LinkedList(subList));
        this.fireEntriesPushed(numWords);
        if (depth != 0) {
            this.fireEntriesChanged(depth + numWords);
        }
    }

    public void swapWords(int n1, int n2) throws VerificationException {
        if (n1 + n2 == 0) {
            return;
        }
        this.checkLastIndex(n1 + n2);
        this.restore = false;
        List subList = this.list.subList(0, n1);
        LinkedList subListCopy = new LinkedList(subList);
        subList.clear();
        this.list.addAll(n2, subListCopy);
        this.fireEntriesChanged(n1 + n2);
    }

    public void restorePointStart() {
        this.restore = true;
        this.restoreList.clear();
    }

    public void restore() {
        if (!this.restore) {
            throw new IllegalStateException("Cannot restore after push, popWords, dupWords or swapWords");
        }
        Iterator i = this.restoreList.iterator();
        while (i.hasNext()) {
            this.push((StackEntry)i.next());
        }
        this.restore = false;
    }

    public void addStackEntryListListener(StackEntryListListener l) {
        this.listeners.add(class$carmel$interpreter$OperandStackListener == null ? (class$carmel$interpreter$OperandStackListener = OperandStack.class$("carmel.interpreter.OperandStackListener")) : class$carmel$interpreter$OperandStackListener, l);
    }

    public void removeStackEntryListListener(StackEntryListListener l) {
        this.listeners.remove(class$carmel$interpreter$OperandStackListener == null ? (class$carmel$interpreter$OperandStackListener = OperandStack.class$("carmel.interpreter.OperandStackListener")) : class$carmel$interpreter$OperandStackListener, l);
    }

    protected void fireEntriesPopped(int numWords) {
        OperandStackEvent e = new OperandStackEvent(this, numWords);
        Object[] list = this.listeners.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$carmel$interpreter$OperandStackListener == null ? OperandStack.class$("carmel.interpreter.OperandStackListener") : class$carmel$interpreter$OperandStackListener)) continue;
            ((OperandStackListener)list[i + 1]).entriesPopped(e);
        }
    }

    protected void fireEntriesPushed(int numWords) {
        OperandStackEvent e = new OperandStackEvent(this, numWords);
        Object[] list = this.listeners.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$carmel$interpreter$OperandStackListener == null ? OperandStack.class$("carmel.interpreter.OperandStackListener") : class$carmel$interpreter$OperandStackListener)) continue;
            ((OperandStackListener)list[i + 1]).entriesPushed(e);
        }
    }

    protected void fireEntriesChanged(int numWords) {
        OperandStackEvent e = new OperandStackEvent(this, numWords);
        Object[] list = this.listeners.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$carmel$interpreter$OperandStackListener == null ? OperandStack.class$("carmel.interpreter.OperandStackListener") : class$carmel$interpreter$OperandStackListener)) continue;
            ((OperandStackListener)list[i + 1]).entriesChanged(e);
        }
    }

    protected void checkLastIndex(int index) throws VerificationException {
        if (index > this.list.size()) {
            throw new VerificationException("Stack size too small");
        }
        if (index != this.list.size() && this.list.get(index) == BottomValue.BOTTOM) {
            throw new VerificationException("Attempt to break apart a double word");
        }
    }

    public int getEntryListSize() {
        return this.list.size();
    }

    public StackEntry getEntryNoVerification(int index) {
        return (StackEntry)this.list.get(index);
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

