/*
 * Decompiled with CFR 0.152.
 */
package carmel.interpreter;

import carmel.interpreter.LocalVariableArrayEvent;
import carmel.interpreter.LocalVariableArrayListener;
import carmel.interpreter.StackEntryList;
import carmel.interpreter.StackEntryListListener;
import carmel.interpreter.VerificationException;
import carmel.type.JCVMByteType;
import carmel.type.JCVMShortType;
import carmel.type.JCVMType;
import carmel.type.TypeException;
import carmel.value.BottomValue;
import carmel.value.ByteValue;
import carmel.value.ClassValue;
import carmel.value.ShortValue;
import carmel.value.StackEntry;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;

public class LocalVariableArray
implements StackEntryList {
    protected StackEntry[] variables;
    protected EventListenerList listeners = new EventListenerList();
    protected boolean firstEntryProtected = false;
    static Class class$carmel$interpreter$LocalVariableArrayListener;

    public LocalVariableArray(int size) {
        this.variables = new StackEntry[size];
    }

    public LocalVariableArray(int size, List parameterEntries) {
        this(size);
        this.fireVariablesChanged(0, this.addList(0, parameterEntries));
    }

    public LocalVariableArray(int size, ClassValue classValue, List parameterEntries) {
        this(size);
        this.firstEntryProtected = true;
        this.variables[0] = classValue;
        this.fireVariablesChanged(0, this.addList(1, parameterEntries));
    }

    protected int addList(int index, List list) {
        try {
            Iterator i22 = list.iterator();
            while (i22.hasNext()) {
                StackEntry o = (StackEntry)i22.next();
                this.set(index++, o);
                if (!o.getJCVMType().isDoubleWord()) continue;
                ++index;
            }
            int i22 = index;
            return i22;
        }
        catch (VerificationException e) {
            throw new Error("Unexpected VerificationException in addList");
        }
    }

    public StackEntry get(int index) throws VerificationException {
        StackEntry o = this.variables[index];
        if (o == null) {
            throw new VerificationException("Attempt to access an uninitialised local variable");
        }
        if (BottomValue.BOTTOM.equals(o)) {
            throw new VerificationException("Attempt to access second word of a double word local variable");
        }
        return o;
    }

    public StackEntry get(int index, JCVMType type) throws TypeException, VerificationException {
        if (type == JCVMByteType.TYPE) {
            return ByteValue.fromShort((ShortValue)this.get(index, JCVMShortType.TYPE));
        }
        StackEntry o = this.get(index);
        type.checkType(o);
        return o;
    }

    public void set(int index, StackEntry o) throws VerificationException {
        JCVMType type;
        if (o == null) {
            throw new NullPointerException("Null is not a valid local variable value");
        }
        if (this.firstEntryProtected && index == 0) {
            throw new VerificationException("Class value at index 0 cannot be modified");
        }
        if (this.variables[index] == BottomValue.BOTTOM) {
            this.variables[index - 1] = BottomValue.BOTTOM;
        }
        if ((type = o.getJCVMType()) == JCVMByteType.TYPE) {
            o = ((ByteValue)o).toShort();
        }
        this.variables[index] = o;
        if (type.isDoubleWord()) {
            this.variables[index + 1] = BottomValue.BOTTOM;
            this.fireVariablesChanged(index, index + 1);
        } else {
            this.fireVariablesChanged(index, index);
        }
    }

    public int getSize() {
        return this.variables.length;
    }

    public void addStackEntryListListener(StackEntryListListener l) {
        this.listeners.add(class$carmel$interpreter$LocalVariableArrayListener == null ? (class$carmel$interpreter$LocalVariableArrayListener = LocalVariableArray.class$("carmel.interpreter.LocalVariableArrayListener")) : class$carmel$interpreter$LocalVariableArrayListener, l);
    }

    public void removeStackEntryListListener(StackEntryListListener l) {
        this.listeners.remove(class$carmel$interpreter$LocalVariableArrayListener == null ? (class$carmel$interpreter$LocalVariableArrayListener = LocalVariableArray.class$("carmel.interpreter.LocalVariableArrayListener")) : class$carmel$interpreter$LocalVariableArrayListener, l);
    }

    protected void fireVariablesChanged(int firstIndex, int lastIndex) {
        LocalVariableArrayEvent e = new LocalVariableArrayEvent(this, firstIndex, lastIndex);
        Object[] list = this.listeners.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$carmel$interpreter$LocalVariableArrayListener == null ? LocalVariableArray.class$("carmel.interpreter.LocalVariableArrayListener") : class$carmel$interpreter$LocalVariableArrayListener)) continue;
            ((LocalVariableArrayListener)list[i + 1]).variablesChanged(e);
        }
    }

    public int getEntryListSize() {
        return this.getSize();
    }

    public StackEntry getEntryNoVerification(int index) {
        return this.variables[index];
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

