/*
 * Decompiled with CFR 0.152.
 */
package carmel.interpreter;

import carmel.interpreter.HeapEvent;
import carmel.interpreter.HeapListener;
import carmel.value.NonNullReferenceValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.event.EventListenerList;

public class Heap {
    protected short nextFreeLocation = 0;
    protected ArrayList mappings = new ArrayList();
    protected EventListenerList listeners = new EventListenerList();
    static Class class$carmel$interpreter$HeapListener;

    public short allocate(NonNullReferenceValue value) {
        short location = this.nextFreeLocation;
        this.nextFreeLocation = (short)(this.nextFreeLocation + value.getSizeInBytes());
        this.mappings.add(new Mapping(this, location, value));
        this.fireHeapAllocationEvent(this.mappings.size() - 1);
        return location;
    }

    public NonNullReferenceValue lookup(short location) {
        int index = this.getIndexForLocation(location);
        return index == -1 ? null : ((Mapping)this.mappings.get((int)index)).value;
    }

    public int getIndexForLocation(short location) {
        int index = Collections.binarySearch(this.mappings, new Mapping(this, location));
        return index < 0 ? -1 : index;
    }

    public short getSizeInBytes() {
        return this.nextFreeLocation;
    }

    public int getMappingCount() {
        return this.mappings.size();
    }

    public Mapping getMapping(int index) {
        return (Mapping)this.mappings.get(index);
    }

    public Collection getMappings() {
        return this.mappings;
    }

    public void addHeapListener(HeapListener l) {
        this.listeners.add(class$carmel$interpreter$HeapListener == null ? (class$carmel$interpreter$HeapListener = Heap.class$("carmel.interpreter.HeapListener")) : class$carmel$interpreter$HeapListener, l);
    }

    public void removeHeapListener(HeapListener l) {
        this.listeners.remove(class$carmel$interpreter$HeapListener == null ? (class$carmel$interpreter$HeapListener = Heap.class$("carmel.interpreter.HeapListener")) : class$carmel$interpreter$HeapListener, l);
    }

    protected void fireHeapAllocationEvent(int index) {
        HeapEvent e = new HeapEvent(this, index);
        Object[] list = this.listeners.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$carmel$interpreter$HeapListener == null ? Heap.class$("carmel.interpreter.HeapListener") : class$carmel$interpreter$HeapListener)) continue;
            ((HeapListener)list[i + 1]).newAllocation(e);
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    public class Mapping
    implements Comparable {
        protected short location;
        protected NonNullReferenceValue value = null;

        protected Mapping(Heap this$0, short location) {
            this.location = location;
        }

        protected Mapping(Heap this$0, short location, NonNullReferenceValue value) {
            this.location = location;
            this.value = value;
        }

        public short getLocation() {
            return this.location;
        }

        public NonNullReferenceValue getValue() {
            return this.value;
        }

        public int compareTo(Object o) {
            return this.location - ((Mapping)o).location;
        }

        public boolean equals(Object o) {
            return this.location == ((Mapping)o).location;
        }

        public int hashCode() {
            return this.location;
        }
    }
}

