/*
 * Decompiled with CFR 0.152.
 */
package carmel.interpreter;

import carmel.interpreter.CarmelSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class FileCarmelSource
extends CarmelSource {
    protected File file;

    public FileCarmelSource(File file) throws FileNotFoundException {
        super(file.getName());
        if (!file.exists()) {
            throw new FileNotFoundException(String.valueOf(String.valueOf(file.getAbsolutePath())).concat(" not found"));
        }
        this.file = file;
    }

    public boolean isReadOnly() {
        return false;
    }

    public int getLength() {
        return (int)this.file.length();
    }

    public Reader openReader() throws IOException {
        try {
            FileReader fileReader = new FileReader(this.file);
            return fileReader;
        }
        catch (FileNotFoundException e) {
            throw new IOException(e.getMessage());
        }
    }

    public Writer openWriter() throws IOException {
        try {
            FileWriter fileWriter = new FileWriter(this.file);
            return fileWriter;
        }
        catch (FileNotFoundException e) {
            throw new IOException(e.getMessage());
        }
    }
}

