/*
 * Decompiled with CFR 0.152.
 */
package carmel.interpreter;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public abstract class CarmelSource {
    protected String name;
    protected int length;

    public CarmelSource(String name) {
        this.name = name;
    }

    public CarmelSource(String name, int length) {
        this(name);
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isReadOnly() {
        return true;
    }

    public abstract Reader openReader() throws IOException;

    public Writer openWriter() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Source is read only");
    }

    public String getContents() throws IOException {
        char[] contents = new char[this.getLength()];
        Reader reader = this.openReader();
        reader.read(contents);
        reader.close();
        return new String(contents);
    }

    public void setContents(String string) throws IOException, UnsupportedOperationException {
        Writer writer = this.openWriter();
        writer.write(string);
        writer.close();
    }
}

