/*
 * Decompiled with CFR 0.152.
 */
package carmel.interpreter;

import carmel.interpreter.CallStack;
import carmel.interpreter.StackFrame;
import carmel.value.ClassValue;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;

public class CarmelException
extends Exception {
    protected ClassValue exception;
    protected LinkedList stackTrace = new LinkedList();
    protected CallStack callStack = null;

    public CarmelException(ClassValue exception) {
        this.exception = exception;
    }

    public ClassValue getException() {
        return this.exception;
    }

    protected void addFrame(StackFrame frame) {
        this.stackTrace.add(frame);
    }

    public CallStack getCallStack() {
        return this.callStack == null ? (this.callStack = new CallStack(this.stackTrace)) : this.callStack;
    }

    public void printCarmelStackTrace() {
        this.printCarmelStackTrace(System.err);
    }

    public void printCarmelStackTrace(PrintStream s) {
        String message = this.getMessage();
        s.print(this.exception.getType().getName());
        if (message != null) {
            s.print(": ");
            s.print(message);
        }
        s.println();
        Iterator i = this.stackTrace.iterator();
        while (i.hasNext()) {
            StackFrame frame = (StackFrame)i.next();
            s.print("\tat ");
            s.print(frame.getMethod().getName());
            s.print('(');
            s.print(frame.getCarmelSource().getName());
            s.print(':');
            s.print(frame.getPC().getLineNumber());
            s.println(')');
        }
    }
}

