/*
 * Decompiled with CFR 0.152.
 */
package carmel.interpreter;

import carmel.interpreter.CarmelSource;
import carmel.interpreter.ClassLoaderEvent;
import carmel.interpreter.ClassLoaderListener;
import carmel.interpreter.Heap;
import carmel.interpreter.PackageNotFoundException;
import carmel.interpreter.URLCarmelSource;
import carmel.parser.LexOrParseException;
import carmel.parser.ParseException;
import carmel.parser.Parser;
import carmel.tree.LinkPass1Visitor;
import carmel.tree.LinkPass2Visitor;
import carmel.tree.TreeClass;
import carmel.tree.TreeClassOrInterface;
import carmel.tree.TreePackage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;

public class CarmelClassLoader {
    protected static final int LINK_PASSES = 2;
    public final TreeClass object;
    public final TreeClass throwable;
    public final TreeClass runtimeException;
    protected HashMap[] pendingPackages;
    protected HashMap packages = new HashMap();
    protected HashMap packagesByAID = new HashMap();
    protected Heap heap;
    protected EventListenerList listeners = new EventListenerList();
    static Class class$carmel$interpreter$ClassLoaderListener;

    public static String getPackageFilename(String packageName) {
        return packageName == null ? "carmel/null.cml" : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(packageName.replace('.', '/')))).append("/carmel/").append(packageName.substring(packageName.lastIndexOf(46) + 1)).append(".cml")));
    }

    public CarmelClassLoader(Heap heap) throws LexOrParseException, ClassNotFoundException {
        this.heap = heap;
        this.pendingPackages = new HashMap[3];
        for (int i = 0; i <= 2; ++i) {
            this.pendingPackages[i] = new HashMap();
        }
        this.object = (TreeClass)this.loadClass("java.lang.Object");
        this.throwable = (TreeClass)this.loadClass("java.lang.Throwable");
        this.runtimeException = (TreeClass)this.loadClass("java.lang.RuntimeException");
    }

    public Collection getPackages() {
        return this.packages.values();
    }

    public TreeClassOrInterface loadClass(String name) throws LexOrParseException, ClassNotFoundException {
        TreeClassOrInterface c = this.loadClass(name, 3);
        this.commit();
        return c;
    }

    public TreeClassOrInterface loadClass(String name, int linkPass) throws LexOrParseException, ClassNotFoundException {
        int index = name.lastIndexOf(46);
        String packageName = index == -1 ? null : name.substring(0, index);
        String className = name.substring(index + 1);
        try {
            TreeClassOrInterface c = this.loadPackage(packageName, linkPass).getClassOrInterface(className);
            if (c != null) {
                TreeClassOrInterface treeClassOrInterface = c;
                return treeClassOrInterface;
            }
        }
        catch (PackageNotFoundException packageNotFoundException) {
            // empty catch block
        }
        this.abandon();
        throw new ClassNotFoundException(String.valueOf(String.valueOf(new StringBuffer("Class ").append(name).append(" not found"))));
    }

    public TreePackage loadPackage(String name) throws PackageNotFoundException, LexOrParseException {
        TreePackage p = this.loadPackage(name, 3);
        this.commit();
        return p;
    }

    public TreePackage loadPackage(String name, int linkPass) throws PackageNotFoundException, LexOrParseException {
        int i;
        TreePackage p;
        block8: {
            p = (TreePackage)this.packages.get(name);
            if (p != null) {
                return p;
            }
            for (i = 2; i >= linkPass; --i) {
                p = (TreePackage)this.pendingPackages[i].get(name);
                if (p == null) continue;
                return p;
            }
            for (i = linkPass - 1; i >= 0; --i) {
                p = (TreePackage)this.pendingPackages[i].get(name);
                if (p == null) {
                    continue;
                }
                break block8;
            }
            if (linkPass > 0) {
                p = this.linkPackage(name, 0);
            }
        }
        for (i = 0; i <= linkPass - 2; ++i) {
            Collection c;
            while (!(c = this.pendingPackages[i].values()).isEmpty()) {
                this.linkPackage(((TreePackage)c.iterator().next()).getName(), i + 1);
            }
        }
        if (linkPass == 3) {
            return p;
        }
        return this.linkPackage(name, linkPass);
    }

    protected void abandon() {
        for (int i = 0; i <= 2; ++i) {
            this.pendingPackages[i].clear();
        }
    }

    protected TreePackage linkPackage(String name, int linkPass) throws LexOrParseException, PackageNotFoundException {
        try {
            TreePackage p = null;
            if (linkPass > 0) {
                p = (TreePackage)this.pendingPackages[linkPass - 1].get(name);
            }
            switch (linkPass) {
                case 0: {
                    URL url = this.getClass().getClassLoader().getResource(CarmelClassLoader.getPackageFilename(name));
                    if (url == null) {
                        throw new PackageNotFoundException();
                    }
                    try {
                        p = new Parser(this.heap, URLCarmelSource.createCarmelSource(url)).parsePackage();
                        break;
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        throw new PackageNotFoundException();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new PackageNotFoundException();
                    }
                }
                case 1: {
                    new LinkPass1Visitor(this).visitPackage(p);
                    break;
                }
                case 2: {
                    new LinkPass2Visitor(this).visitPackage(p);
                    break;
                }
                default: {
                    throw new Error("Invalid link pass: ".concat(String.valueOf(String.valueOf(linkPass))));
                }
            }
            if (linkPass > 0) {
                this.pendingPackages[linkPass - 1].remove(name);
            }
            this.pendingPackages[linkPass].put(name, p);
            TreePackage treePackage = p;
            return treePackage;
        }
        catch (PackageNotFoundException e) {
            this.abandon();
            throw e;
        }
        catch (LexOrParseException e) {
            this.abandon();
            throw e;
        }
    }

    protected void commit() {
        this.packages.putAll(this.pendingPackages[2]);
        Iterator i = this.pendingPackages[2].values().iterator();
        while (i.hasNext()) {
            this.firePackageLoaded((TreePackage)i.next());
        }
        this.abandon();
    }

    public List loadMultiPackageFile(CarmelSource source) throws LexOrParseException, IOException {
        List trees = new Parser(this.heap, source).parsePackages();
        Iterator i = trees.iterator();
        while (i.hasNext()) {
            TreePackage p = (TreePackage)i.next();
            if (this.packages.get(p.getName()) != null) {
                ParseException e = new ParseException(String.valueOf(String.valueOf(new StringBuffer("A package with name ").append(p.getName()).append(" has already been declared"))), p.token);
                e.setSource(source);
                throw e;
            }
            this.pendingPackages[0].put(p.getName(), p);
        }
        try {
            i = trees.iterator();
            while (i.hasNext()) {
                this.loadPackage(((TreePackage)i.next()).getName(), 3);
            }
        }
        catch (PackageNotFoundException e) {
            this.abandon();
            throw new InternalError("unexpected PackageNotFoundException");
        }
        this.commit();
        return trees;
    }

    public void addClassLoaderListener(ClassLoaderListener l) {
        this.listeners.add(class$carmel$interpreter$ClassLoaderListener == null ? (class$carmel$interpreter$ClassLoaderListener = CarmelClassLoader.class$("carmel.interpreter.ClassLoaderListener")) : class$carmel$interpreter$ClassLoaderListener, l);
    }

    public void removeClassLoaderListener(ClassLoaderListener l) {
        this.listeners.remove(class$carmel$interpreter$ClassLoaderListener == null ? (class$carmel$interpreter$ClassLoaderListener = CarmelClassLoader.class$("carmel.interpreter.ClassLoaderListener")) : class$carmel$interpreter$ClassLoaderListener, l);
    }

    protected void firePackageLoaded(TreePackage p) {
        ClassLoaderEvent e = new ClassLoaderEvent(this, p);
        Object[] list = this.listeners.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$carmel$interpreter$ClassLoaderListener == null ? CarmelClassLoader.class$("carmel.interpreter.ClassLoaderListener") : class$carmel$interpreter$ClassLoaderListener)) continue;
            ((ClassLoaderListener)list[i + 1]).packageLoaded(e);
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        LINK_PASSES = 2;
    }
}

