/*
 * Decompiled with CFR 0.152.
 */
package carmel.interpreter;

import carmel.interpreter.CallStackEvent;
import carmel.interpreter.CallStackListener;
import carmel.interpreter.StackFrame;
import java.util.LinkedList;
import javax.swing.event.EventListenerList;

public class CallStack {
    protected LinkedList list;
    protected EventListenerList listeners = new EventListenerList();
    static Class class$carmel$interpreter$CallStackListener;

    public CallStack() {
        this(new LinkedList());
    }

    protected CallStack(LinkedList frames) {
        this.list = frames;
    }

    public void push(StackFrame f) {
        this.list.addFirst(f);
        this.fireFramePushed(f);
    }

    public StackFrame pop() {
        StackFrame frame = (StackFrame)this.list.removeFirst();
        this.fireFramePopped(frame);
        return frame;
    }

    public StackFrame peek() {
        return (StackFrame)this.list.getFirst();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void setStack(CallStack stack) {
        this.clear();
        LinkedList newList = (LinkedList)stack.list.clone();
        while (!newList.isEmpty()) {
            this.push((StackFrame)newList.removeLast());
        }
    }

    public void clear() {
        while (!this.isEmpty()) {
            this.pop();
        }
    }

    public int getDepth() {
        return this.list.size();
    }

    public StackFrame getFrame(int depth) {
        return (StackFrame)this.list.get(depth);
    }

    public void addCallStackListener(CallStackListener l) {
        this.listeners.add(class$carmel$interpreter$CallStackListener == null ? (class$carmel$interpreter$CallStackListener = CallStack.class$("carmel.interpreter.CallStackListener")) : class$carmel$interpreter$CallStackListener, l);
    }

    public void removeCallStackListener(CallStackListener l) {
        this.listeners.remove(class$carmel$interpreter$CallStackListener == null ? (class$carmel$interpreter$CallStackListener = CallStack.class$("carmel.interpreter.CallStackListener")) : class$carmel$interpreter$CallStackListener, l);
    }

    protected void fireFramePushed(StackFrame frame) {
        CallStackEvent e = new CallStackEvent(this, frame);
        Object[] list = this.listeners.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$carmel$interpreter$CallStackListener == null ? CallStack.class$("carmel.interpreter.CallStackListener") : class$carmel$interpreter$CallStackListener)) continue;
            ((CallStackListener)list[i + 1]).framePushed(e);
        }
    }

    protected void fireFramePopped(StackFrame frame) {
        CallStackEvent e = new CallStackEvent(this, frame);
        Object[] list = this.listeners.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$carmel$interpreter$CallStackListener == null ? CallStack.class$("carmel.interpreter.CallStackListener") : class$carmel$interpreter$CallStackListener)) continue;
            ((CallStackListener)list[i + 1]).framePopped(e);
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

