/*
 * Decompiled with CFR 0.152.
 */
package carmel.gui;

import carmel.gui.ArrayValueTableModel;
import carmel.gui.CallStackTableModel;
import carmel.gui.CarmelSourcePanel;
import carmel.gui.ClassLoaderNodeVisitor;
import carmel.gui.ClassLoaderTreeModel;
import carmel.gui.ClassPathEditorPanel;
import carmel.gui.ClassValueTableModel;
import carmel.gui.HeapTableModel;
import carmel.gui.LoadCarmelSourcePanel;
import carmel.gui.LocalVariableArrayTableModel;
import carmel.gui.OperandStackTableModel;
import carmel.gui.PrototypeValueTableModel;
import carmel.gui.SourceErrorDialog;
import carmel.gui.StaticFieldTableModel;
import carmel.interpreter.CallStack;
import carmel.interpreter.CarmelException;
import carmel.interpreter.Heap;
import carmel.interpreter.HeapEvent;
import carmel.interpreter.HeapListener;
import carmel.interpreter.PCEvent;
import carmel.interpreter.PCListener;
import carmel.interpreter.PackageNotFoundException;
import carmel.interpreter.StackFrame;
import carmel.interpreter.VerificationException;
import carmel.interpreter.VirtualMachine;
import carmel.interpreter.VirtualMachineListener;
import carmel.parser.LexOrParseException;
import carmel.tree.TreeClassOrInterface;
import carmel.tree.TreeConstructor;
import carmel.tree.TreeConstructorOrMethod;
import carmel.tree.TreeMethod;
import carmel.tree.TreePackage;
import carmel.value.ArrayValue;
import carmel.value.ClassValue;
import carmel.value.NonNullReferenceValue;
import carmel.value.ReferenceValue;
import carmel.value.Value;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.NoSuchElementException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import javax.swing.tree.TreePath;

public class VMFrame
extends JFrame {
    protected Action loadPackageAction;
    protected Action loadFileAction;
    protected Action setClassPathAction;
    protected Action runMethodAction;
    protected Action stepIntoAction;
    protected Action stepOverAction;
    protected Action stepOutAction;
    protected Action haltAction;
    protected Action closeAction;
    protected CallStackTableModel callStackTableModel = new CallStackTableModel();
    protected SingleListSelectionModel callStackTableSelectionModel = new SingleListSelectionModel(this);
    protected OperandStackTableModel operandStackTableModel = new OperandStackTableModel();
    protected LocalVariableArrayTableModel localVariablesTableModel = new LocalVariableArrayTableModel();
    protected HeapTableModel heapTableModel = new HeapTableModel();
    protected SingleListSelectionModel heapTableSelectionModel = new SingleListSelectionModel(this);
    protected ClassValueTableModel classValueTableModel = new ClassValueTableModel();
    protected ArrayValueTableModel arrayValueTableModel = new ArrayValueTableModel();
    protected ClassLoaderTreeModel classTreeModel = new ClassLoaderTreeModel();
    protected StaticFieldTableModel staticFieldsTableModel = new StaticFieldTableModel();
    protected ClassPathEditorPanel classPathEditorPanel = new ClassPathEditorPanel();
    protected LoadCarmelSourcePanel loadCarmelSourcePanel = new LoadCarmelSourcePanel();
    TitledBorder heapBorder;
    TitledBorder staticFieldsBorder;
    TitledBorder callStackBorder;
    TitledBorder localVariablesBorder;
    TitledBorder operandStackBorder;
    TitledBorder fileViewerBorder;
    BorderLayout borderLayout3 = new BorderLayout();
    JSplitPane splitPane = new JSplitPane();
    JScrollPane callStackScrollPane = new JScrollPane();
    JSplitPane callStackSplitPane = new JSplitPane();
    JScrollPane operandStackScrollPane = new JScrollPane();
    JTable callStackTable = new JTable();
    JTable localVariablesTable = new JTable();
    JPanel framePanel = new JPanel();
    JTable operandStackTable = new JTable();
    JPanel vmStatePanel = new JPanel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JScrollPane localVariablesScrollPane = new JScrollPane();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel heapInfoLabel = new JLabel();
    JScrollPane heapTableScrollPane = new JScrollPane();
    JPanel heapPanel = new JPanel();
    JSplitPane heapSplitPane = new JSplitPane();
    JTable heapTable = new JTable();
    JSplitPane sourceSplitPane = new JSplitPane();
    CarmelSourcePanel carmelSourcePanel = new CarmelSourcePanel();
    JScrollPane staticFieldsScrollPane = new JScrollPane();
    JScrollPane classTreeScrollPane = new JScrollPane();
    JSplitPane staticFieldsSplitPane = new JSplitPane();
    JTable staticFieldsTable = new JTable();
    JTree classTree = new JTree();
    JPanel buttonPanel = new JPanel();
    JButton stepIntoButton = new JButton();
    JButton closeButton = new JButton();
    JButton stepOutButton = new JButton();
    JButton stepOverButton = new JButton();
    JPanel runButtonPanel = new JPanel();
    CardLayout buttonPanelCardLayout = new CardLayout();
    JPanel loadButtonPanel = new JPanel();
    JButton loadPackageButton = new JButton();
    JButton loadFileButton = new JButton();
    JButton setClassPathButton = new JButton();
    JButton runMethodButton = new JButton();
    JButton close2Button = new JButton();
    JButton haltButton = new JButton();
    JTable valueExplorerTable = new JTable();
    JScrollPane valueExplorerScrollPane = new JScrollPane();
    static Class class$carmel$value$StackEntry;

    public VMFrame(String fileName) {
        this();
        this.loadCarmelSourcePanel.setFileName(fileName);
    }

    public VMFrame() {
        super("Carmel Interpreter");
        try {
            final VirtualMachine vm = new VirtualMachine();
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    VMFrame.this.closeWindow(vm);
                }
            });
            this.loadPackageAction = new AbstractAction("Load Package..."){

                public void actionPerformed(ActionEvent event) {
                    String name = JOptionPane.showInputDialog(null, "Enter package name", "Load package", 3);
                    if (name != null) {
                        try {
                            TreePackage p = vm.getClassLoader().loadPackage(name);
                            VMFrame.this.classTree.getSelectionModel().setSelectionPath(new TreePath(VMFrame.this.classTreeModel.getPackageNode(p).getPath()));
                        }
                        catch (LexOrParseException e) {
                            new SourceErrorDialog(null, e, "Compile error").show();
                        }
                        catch (PackageNotFoundException e) {
                            JOptionPane.showMessageDialog(null, "Package not found.  Ensure that its .cml file is in the class path.", "Package not found", 0);
                        }
                    }
                }
            };
            this.loadPackageButton.setAction(this.loadPackageAction);
            this.loadFileAction = new AbstractAction("Load File..."){

                public void actionPerformed(ActionEvent event) {
                    if (JOptionPane.showConfirmDialog(null, VMFrame.this.loadCarmelSourcePanel, "Open Carmel Source", 2) == 0) {
                        try {
                            TreePackage p = (TreePackage)vm.getClassLoader().loadMultiPackageFile(VMFrame.this.loadCarmelSourcePanel.getCarmelSource()).get(0);
                            VMFrame.this.classTree.getSelectionModel().setSelectionPath(new TreePath(VMFrame.this.classTreeModel.getPackageNode(p).getPath()));
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(null, "Error reading file: ".concat(String.valueOf(String.valueOf(e.getMessage()))), "Error", 0);
                        }
                        catch (LexOrParseException e) {
                            new SourceErrorDialog(null, e, "Compile error").show();
                        }
                    }
                }
            };
            this.loadFileButton.setAction(this.loadFileAction);
            this.setClassPathAction = new AbstractAction("Set classpath..."){

                public void actionPerformed(ActionEvent e) {
                    VMFrame.this.classPathEditorPanel.refreshClassPath();
                    if (JOptionPane.showConfirmDialog(null, VMFrame.this.classPathEditorPanel, "Set classpath", 2) == 0) {
                        VMFrame.this.classPathEditorPanel.commitChange();
                    }
                }
            };
            this.setClassPathButton.setAction(this.setClassPathAction);
            this.runMethodAction = new AbstractAction("Run Method"){

                public void actionPerformed(ActionEvent event) {
                    TreePath selectedPath = VMFrame.this.classTree.getAnchorSelectionPath();
                    if (selectedPath != null) {
                        Object selectedNode = selectedPath.getLastPathComponent();
                        if (selectedNode instanceof ClassLoaderTreeModel.MethodNode) {
                            TreeMethod method = ((ClassLoaderTreeModel.MethodNode)selectedNode).getMethod();
                            try {
                                if (method.isStatic()) {
                                    vm.invokeStaticMethod(method);
                                    VMFrame.this.buttonPanelCardLayout.show(VMFrame.this.buttonPanel, "runButtonPanel");
                                } else {
                                    int index = VMFrame.this.heapTableSelectionModel.getSelectedIndex();
                                    if (index != -1) {
                                        NonNullReferenceValue value = vm.getHeap().getMapping(index).getValue();
                                        if (value instanceof ClassValue) {
                                            vm.invokeInstanceMethod(method, (ClassValue)value);
                                            VMFrame.this.buttonPanelCardLayout.show(VMFrame.this.buttonPanel, "runButtonPanel");
                                        }
                                        return;
                                    }
                                    JOptionPane.showMessageDialog(null, "Please select a class instance from the heap on which to execute the method", "Error", 0);
                                }
                            }
                            catch (IllegalArgumentException e) {
                                VMFrame.this.buttonPanelCardLayout.show(VMFrame.this.buttonPanel, "loadButtonPanel");
                                JOptionPane.showMessageDialog(null, "Error invoking method: ".concat(String.valueOf(String.valueOf(e.getMessage()))), "Error", 0);
                            }
                            return;
                        }
                        if (selectedNode instanceof ClassLoaderTreeModel.ConstructorNode) {
                            TreeConstructor c = ((ClassLoaderTreeModel.ConstructorNode)selectedNode).getConstructor();
                            try {
                                vm.invokeConstructor(c);
                                VMFrame.this.buttonPanelCardLayout.show(VMFrame.this.buttonPanel, "runButtonPanel");
                            }
                            catch (IllegalArgumentException e) {
                                JOptionPane.showMessageDialog(null, "Error invoking constructor: ".concat(String.valueOf(String.valueOf(e.getMessage()))), "Error", 0);
                            }
                            return;
                        }
                    }
                    JOptionPane.showMessageDialog(null, "Please select a method or constructor from the \"Loaded Classes\" tree", "Error", 0);
                }
            };
            this.runMethodButton.setAction(this.runMethodAction);
            this.stepIntoAction = new AbstractAction("Step Into"){

                public void actionPerformed(ActionEvent e) {
                    vm.stepInto();
                }
            };
            this.stepIntoButton.setAction(this.stepIntoAction);
            this.stepOverAction = new AbstractAction("Step Over"){

                public void actionPerformed(ActionEvent e) {
                    vm.stepOver();
                }
            };
            this.stepOverButton.setAction(this.stepOverAction);
            this.stepOutAction = new AbstractAction("Step Out"){

                public void actionPerformed(ActionEvent e) {
                    vm.stepOut();
                }
            };
            this.stepOutButton.setAction(this.stepOutAction);
            this.haltAction = new AbstractAction("Halt"){

                public void actionPerformed(ActionEvent e) {
                    vm.halt();
                }
            };
            this.haltButton.setAction(this.haltAction);
            this.closeAction = new AbstractAction("Close"){

                public void actionPerformed(ActionEvent e) {
                    VMFrame.this.closeWindow(vm);
                }
            };
            this.closeButton.setAction(this.closeAction);
            this.close2Button.setAction(this.closeAction);
            this.callStackTable.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent event) {
                    try {
                        VMFrame.this.updateFileTextArea(vm.getCallStack().getFrame(((JTable)event.getSource()).rowAtPoint(event.getPoint())));
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            });
            this.callStackTableSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    int index = ((ListSelectionModel)e.getSource()).getAnchorSelectionIndex();
                    SwingUtilities.invokeLater(new Runnable(this, index){
                        private final /* synthetic */ int val$index;
                        private final /* synthetic */ 12 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$index = val$index;
                        }

                        public void run() {
                            try {
                                StackFrame frame = 12.access$0(this.this$1).getCallStack().getFrame(this.val$index);
                                12.access$1(this.this$1).operandStackTableModel.setOperandStack(frame.getOperandStack());
                                12.access$1(this.this$1).localVariablesTableModel.setStackEntryList(frame.getLocalVariables());
                                12.access$1(this.this$1).updateFileTextArea(frame);
                            }
                            catch (IndexOutOfBoundsException ex) {
                                12.access$1(this.this$1).operandStackTableModel.setOperandStack(null);
                                12.access$1(this.this$1).localVariablesTableModel.setStackEntryList(null);
                            }
                        }
                    });
                }

                static /* synthetic */ VMFrame access$1(12 x$0) {
                    return x$0.VMFrame.this;
                }

                static /* synthetic */ VirtualMachine access$0(12 x$0) {
                    return x$0.vm;
                }
            });
            this.classTree.getSelectionModel().setSelectionMode(1);
            this.classTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    ((ClassLoaderTreeModel.Node)e.getPath().getLastPathComponent()).visit(new ClassLoaderNodeVisitor(this){
                        private final /* synthetic */ 14 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        protected void highlight(int lineNumber) {
                            try {
                                14.access$2(this.this$1).carmelSourcePanel.highlightLine(lineNumber - 1);
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }

                        public void visitPackage(TreePackage p, boolean highlight) {
                            14.access$2(this.this$1).carmelSourcePanel.setCarmelSource(p.getCarmelSource());
                            if (highlight) {
                                this.highlight(p.getLineNumber());
                            }
                        }

                        public void visit(ClassLoaderTreeModel.PackageNode n) {
                            this.visitPackage(n.getPackage(), true);
                            14.access$2(this.this$1).staticFieldsTableModel.setClassOrInterface(null);
                        }

                        public void visitClassOrInterface(TreeClassOrInterface c, boolean highlight) {
                            this.visitPackage(c.getPackage(), false);
                            if (highlight) {
                                this.highlight(c.getLineNumber());
                            }
                            14.access$2(this.this$1).staticFieldsTableModel.setClassOrInterface(c);
                        }

                        public void visit(ClassLoaderTreeModel.ClassNode n) {
                            this.visitClassOrInterface(n.getClassOrInterface(), true);
                        }

                        public void visit(ClassLoaderTreeModel.InterfaceNode n) {
                            this.visitClassOrInterface(n.getClassOrInterface(), true);
                        }

                        public void visitConstructorOrMethod(TreeConstructorOrMethod m) {
                            this.visitClassOrInterface(m.getParentClass(), false);
                            this.highlight(m.getLineNumber());
                        }

                        public void visit(ClassLoaderTreeModel.ConstructorNode n) {
                            this.visitConstructorOrMethod(n.getConstructorOrMethod());
                        }

                        public void visit(ClassLoaderTreeModel.MethodNode n) {
                            this.visitConstructorOrMethod(n.getConstructorOrMethod());
                        }
                    });
                }

                static /* synthetic */ VMFrame access$2(14 x$0) {
                    return x$0.VMFrame.this;
                }
            });
            this.heapTableSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    int index = VMFrame.this.heapTableSelectionModel.getSelectedIndex();
                    if (index == -1) {
                        VMFrame.this.valueExplorerTable.setModel(null);
                    } else {
                        NonNullReferenceValue value = vm.getHeap().getMapping(index).getValue();
                        if (value instanceof ClassValue) {
                            VMFrame.this.classValueTableModel.setClassValue((ClassValue)value);
                            VMFrame.this.valueExplorerTable.setModel(VMFrame.this.classValueTableModel);
                        } else if (value instanceof ArrayValue) {
                            VMFrame.this.arrayValueTableModel.setStackEntryList((ArrayValue)value);
                            VMFrame.this.valueExplorerTable.setModel(VMFrame.this.arrayValueTableModel);
                        } else {
                            throw new InternalError("Unknown NonNullReferenceValue: ".concat(String.valueOf(String.valueOf(value.getClass().getName()))));
                        }
                        SwingUtilities.invokeLater(new Runnable(this, index){
                            private final /* synthetic */ int val$index;
                            private final /* synthetic */ 16 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$index = val$index;
                            }

                            public void run() {
                                16.access$3(this.this$1).heapTable.scrollRectToVisible(16.access$3(this.this$1).heapTable.getCellRect(this.val$index, 0, true));
                            }
                        });
                    }
                }

                static /* synthetic */ VMFrame access$3(16 x$0) {
                    return x$0.VMFrame.this;
                }
            });
            Heap heap = vm.getHeap();
            CallStack callStack = vm.getCallStack();
            this.callStackTableModel.setCallStack(callStack);
            this.heapTableModel.setHeap(heap);
            this.classTreeModel.setClassLoader(vm.getClassLoader());
            this.callStackTableSelectionModel.setSelectedIndex(0);
            this.heapTableSelectionModel.setSelectedIndex(0);
            this.heapInfoLabel.setText(String.valueOf(String.valueOf(new StringBuffer("Heap size ").append(heap.getSizeInBytes()).append(" bytes"))));
            heap.addHeapListener(new HeapListener(){

                public void newAllocation(HeapEvent e) {
                    VMFrame.this.heapInfoLabel.setText(String.valueOf(String.valueOf(new StringBuffer("Heap size ").append(((Heap)e.getSource()).getSizeInBytes()).append(" bytes"))));
                }
            });
            vm.addPCListener(new PCListener(){

                public void pcChanged(PCEvent e) {
                    if (VMFrame.this.callStackTableSelectionModel.isSelectedIndex(0)) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 19 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                try {
                                    19.access$4(this.this$1).updateFileTextArea(19.access$5(this.this$1).getCallStack().peek());
                                }
                                catch (NoSuchElementException noSuchElementException) {
                                    // empty catch block
                                }
                            }
                        });
                    } else {
                        VMFrame.this.callStackTableSelectionModel.setSelectedIndex(0);
                    }
                }

                static /* synthetic */ VMFrame access$4(19 x$0) {
                    return x$0.VMFrame.this;
                }

                static /* synthetic */ VirtualMachine access$5(19 x$0) {
                    return x$0.vm;
                }
            });
            vm.addVMListener(new VirtualMachineListener(){

                private void stopInterpreting() {
                    VMFrame.this.buttonPanelCardLayout.show(VMFrame.this.buttonPanel, "loadButtonPanel");
                }

                public void methodReturned(Value v) {
                    this.stopInterpreting();
                    StringBuffer message = new StringBuffer("Method returned");
                    if (v != null) {
                        message.append(" with value ");
                        if (v instanceof ReferenceValue) {
                            VMFrame.this.heapTableSelectionModel.setSelectedIndex(vm.getHeap().getIndexForLocation(((NonNullReferenceValue)v).getHeapLocation()));
                            message.append(" at heap location ");
                        }
                        message.append(v);
                    }
                    JOptionPane.showMessageDialog(null, message.toString(), "Method return", 1);
                }

                public void methodReturned(CarmelException e) {
                    this.stopInterpreting();
                    ClassValue exception = e.getException();
                    short heapLocation = exception.getHeapLocation();
                    VMFrame.this.heapTableSelectionModel.setSelectedIndex(vm.getHeap().getIndexForLocation(heapLocation));
                    String exceptionName = exception.getType().getName();
                    JOptionPane.showMessageDialog(null, String.valueOf(String.valueOf(new StringBuffer("Method threw exception of type ").append(exceptionName).append(" (at heap location ").append(heapLocation).append(")"))), exceptionName, 1);
                }

                public void vmException(VerificationException e) {
                    this.stopInterpreting();
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Static verification error (caught at runtime): ".concat(String.valueOf(String.valueOf(e.getMessage()))), "Verification Error", 0);
                }

                public void vmException(Exception e) {
                    this.stopInterpreting();
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Exception", 0);
                }

                public void vmHalted() {
                    this.stopInterpreting();
                }
            });
            this.setTableVisibleRowCount(this.callStackTable, 6);
            this.setTableVisibleRowCount(this.operandStackTable, 5);
            this.setTableVisibleRowCount(this.localVariablesTable, 5);
            this.setTableVisibleRowCount(this.heapTable, 6);
            this.setTableVisibleRowCount(this.valueExplorerTable, 6);
            this.setTableVisibleRowCount(this.staticFieldsTable, 6);
            DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer();
            cellRenderer.setHorizontalAlignment(4);
            this.operandStackTable.setDefaultRenderer(class$carmel$value$StackEntry == null ? (class$carmel$value$StackEntry = VMFrame.class$("carmel.value.StackEntry")) : class$carmel$value$StackEntry, cellRenderer);
            this.localVariablesTable.setDefaultRenderer(class$carmel$value$StackEntry == null ? (class$carmel$value$StackEntry = VMFrame.class$("carmel.value.StackEntry")) : class$carmel$value$StackEntry, cellRenderer);
            this.valueExplorerTable.setDefaultRenderer(class$carmel$value$StackEntry == null ? (class$carmel$value$StackEntry = VMFrame.class$("carmel.value.StackEntry")) : class$carmel$value$StackEntry, cellRenderer);
            this.staticFieldsTable.setDefaultRenderer(class$carmel$value$StackEntry == null ? (class$carmel$value$StackEntry = VMFrame.class$("carmel.value.StackEntry")) : class$carmel$value$StackEntry, cellRenderer);
            this.setTableColumnWidths(this.callStackTable);
            this.setTableColumnWidths(this.operandStackTable);
            this.setTableColumnWidths(this.localVariablesTable);
            this.setTableColumnWidths(this.heapTable);
            this.setTableColumnWidths(this.valueExplorerTable);
            this.setTableColumnWidths(this.staticFieldsTable);
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            ((Component)this).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
            if (frameSize.height > screenSize.height - 30) {
                ((Component)this).setSize(frameSize.width, screenSize.height - 30);
            }
            if (callStack.getDepth() != 0) {
                this.updateFileTextArea(callStack.peek());
            }
            this.show();
            this.splitPane.setDividerLocation(0.5);
            this.callStackSplitPane.setDividerLocation(0.5);
            this.heapSplitPane.setDividerLocation(0.67);
            this.sourceSplitPane.setDividerLocation(0.3);
            this.staticFieldsSplitPane.setDividerLocation(0.67);
            this.classTree.getSelectionModel().setSelectionPath(new TreePath(this.classTreeModel.getPackageNode(vm.getClassLoader().loadPackage("java.lang")).getPath()));
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error loading the virtual machine", 0);
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (args.length == 0) {
            new VMFrame();
        } else {
            new VMFrame(args[0]);
        }
    }

    protected void closeWindow(VirtualMachine vm) {
        System.exit(1);
        vm.halt();
        this.hide();
        this.dispose();
    }

    protected void setTableVisibleRowCount(JTable table, int rowCount) {
        table.setPreferredScrollableViewportSize(new Dimension(table.getPreferredSize().width, rowCount * table.getRowHeight()));
    }

    protected void setTableColumnWidths(JTable table) {
        try {
            PrototypeValueTableModel model = (PrototypeValueTableModel)table.getModel();
            TableColumnModel columns = table.getColumnModel();
            TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
            for (int i = 0; i < model.getColumnCount(); ++i) {
                TableColumn column = columns.getColumn(i);
                column.setPreferredWidth(table.getDefaultRenderer(model.getColumnClass((int)i)).getTableCellRendererComponent((JTable)table, (Object)model.getPrototypeValue((int)i), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width);
                column.setMinWidth(headerRenderer.getTableCellRendererComponent((JTable)table, (Object)column.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)i).getMinimumSize().width);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    protected void updateFileTextArea(StackFrame frame) {
        this.carmelSourcePanel.setCarmelSource(frame.getCarmelSource());
        try {
            this.carmelSourcePanel.highlightLine(frame.getPC().getLineNumber() - 1);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void jbInit() throws Exception {
        this.heapBorder = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Heap");
        this.staticFieldsBorder = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Static Fields");
        this.callStackBorder = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Call Stack");
        this.localVariablesBorder = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Local Variables");
        this.operandStackBorder = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Operand Stack");
        this.fileViewerBorder = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Source Viewer");
        this.getContentPane().setLayout(this.borderLayout3);
        this.callStackSplitPane.setBorder(null);
        this.callStackSplitPane.setResizeWeight(0.5);
        this.operandStackScrollPane.setBorder(this.operandStackBorder);
        this.callStackTable.setModel(this.callStackTableModel);
        this.callStackTable.setSelectionModel(this.callStackTableSelectionModel);
        this.callStackTable.setPreferredScrollableViewportSize(new Dimension(300, 300));
        this.localVariablesTable.setModel(this.localVariablesTableModel);
        this.framePanel.setLayout(this.gridBagLayout3);
        this.operandStackTable.setModel(this.operandStackTableModel);
        this.vmStatePanel.setLayout(this.gridBagLayout2);
        this.localVariablesScrollPane.setBorder(this.localVariablesBorder);
        this.splitPane.setOrientation(0);
        this.splitPane.setResizeWeight(0.5);
        this.callStackScrollPane.setBorder(this.callStackBorder);
        this.heapPanel.setLayout(this.borderLayout2);
        this.heapSplitPane.setBorder(this.heapBorder);
        this.heapSplitPane.setResizeWeight(0.5);
        this.heapTable.setModel(this.heapTableModel);
        this.heapTable.setSelectionModel(this.heapTableSelectionModel);
        this.carmelSourcePanel.setBorder(this.fileViewerBorder);
        this.carmelSourcePanel.setReadOnly(true);
        this.carmelSourcePanel.setRows(12);
        this.carmelSourcePanel.setColumns(50);
        this.staticFieldsSplitPane.setOrientation(0);
        this.staticFieldsSplitPane.setBorder(new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Loaded Classes"));
        this.staticFieldsSplitPane.setResizeWeight(0.5);
        this.staticFieldsTable.setModel(this.staticFieldsTableModel);
        this.classTree.setModel(this.classTreeModel);
        this.classTree.setRootVisible(false);
        this.classTree.setShowsRootHandles(true);
        this.classTree.setVisibleRowCount(6);
        this.staticFieldsScrollPane.setBorder(this.staticFieldsBorder);
        this.stepIntoButton.setText("Step Into");
        this.closeButton.setText("Close");
        this.stepOutButton.setText("Step Out");
        this.stepOverButton.setText("Step Over");
        this.buttonPanel.setLayout(this.buttonPanelCardLayout);
        this.loadPackageButton.setText("Load Package...");
        this.loadFileButton.setText("Load File...");
        this.setClassPathButton.setText("Set Classpath...");
        this.runMethodButton.setText("Run Method");
        this.close2Button.setText("Close");
        this.haltButton.setText("Halt");
        this.valueExplorerTable.setModel(this.classValueTableModel);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.splitPane.add((Component)this.vmStatePanel, "top");
        this.framePanel.add((Component)this.localVariablesScrollPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.framePanel.add((Component)this.operandStackScrollPane, new GridBagConstraints(0, 0, 1, 1, 0.6, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.callStackSplitPane.add((Component)this.callStackScrollPane, "left");
        this.callStackScrollPane.getViewport().add((Component)this.callStackTable, null);
        this.operandStackScrollPane.getViewport().add((Component)this.operandStackTable, null);
        this.localVariablesScrollPane.getViewport().add((Component)this.localVariablesTable, null);
        this.callStackSplitPane.add((Component)this.framePanel, "right");
        this.vmStatePanel.add((Component)this.callStackSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.splitPane.add((Component)this.sourceSplitPane, "bottom");
        this.sourceSplitPane.add((Component)this.carmelSourcePanel, "right");
        this.sourceSplitPane.add((Component)this.staticFieldsSplitPane, "left");
        this.sourceSplitPane.setResizeWeight(0.7);
        this.staticFieldsSplitPane.add((Component)this.classTreeScrollPane, "left");
        this.staticFieldsSplitPane.add((Component)this.staticFieldsScrollPane, "right");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.loadButtonPanel, "loadButtonPanel");
        this.loadButtonPanel.add((Component)this.loadPackageButton, null);
        this.loadButtonPanel.add((Component)this.loadFileButton, null);
        this.loadButtonPanel.add((Component)this.setClassPathButton, null);
        this.loadButtonPanel.add((Component)this.runMethodButton, null);
        this.loadButtonPanel.add((Component)this.close2Button, null);
        this.buttonPanel.add((Component)this.runButtonPanel, "runButtonPanel");
        this.runButtonPanel.add((Component)this.stepIntoButton, null);
        this.runButtonPanel.add((Component)this.stepOverButton, null);
        this.runButtonPanel.add((Component)this.stepOutButton, null);
        this.runButtonPanel.add((Component)this.haltButton, null);
        this.runButtonPanel.add((Component)this.closeButton, null);
        this.staticFieldsSplitPane.setResizeWeight(0.33);
        this.staticFieldsScrollPane.getViewport().add((Component)this.staticFieldsTable, null);
        this.classTreeScrollPane.getViewport().add((Component)this.classTree, null);
        this.heapSplitPane.add((Component)this.heapPanel, "left");
        this.heapSplitPane.setResizeWeight(0.67);
        this.heapPanel.add((Component)this.heapTableScrollPane, "Center");
        this.heapPanel.add((Component)this.heapInfoLabel, "South");
        this.heapSplitPane.add((Component)this.valueExplorerScrollPane, "right");
        this.valueExplorerScrollPane.getViewport().add((Component)this.valueExplorerTable, null);
        this.heapTableScrollPane.getViewport().add((Component)this.heapTable, null);
        this.vmStatePanel.add((Component)this.heapSplitPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    protected class SingleListSelectionModel
    extends DefaultListSelectionModel {
        SingleListSelectionModel(VMFrame this$0) {
            this.setSelectionMode(0);
        }

        public int getSelectedIndex() {
            return this.getAnchorSelectionIndex();
        }

        public void setSelectedIndex(int index) {
            this.setSelectionInterval(index, index);
        }

        public void insertIndexInterval(int index, int length, boolean before) {
            super.insertIndexInterval(index, length, before);
            index += length;
            if (before) {
                --index;
            }
            this.setSelectionInterval(index, index);
        }

        public void removeIndexInterval(int index0, int index1) {
            boolean select0 = index0 == 0 && this.isSelectedIndex(0);
            super.removeIndexInterval(index0, index1);
            if (select0) {
                this.setSelectionInterval(0, 0);
            }
        }
    }
}

