/*
 * Decompiled with CFR 0.152.
 */
package carmel.gui;

import carmel.gui.PrototypeValueTableModel;
import carmel.tree.StaticFieldEvent;
import carmel.tree.StaticFieldListener;
import carmel.tree.TreeClassOrInterface;
import carmel.tree.TreeStaticField;
import carmel.value.BottomValue;
import carmel.value.Value;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;

public class StaticFieldTableModel
extends AbstractTableModel
implements StaticFieldListener,
PrototypeValueTableModel {
    protected static final String[] columnNames = new String[]{"Name", "Value", "Type"};
    protected static final Class[] columnClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = StaticFieldTableModel.class$("java.lang.String")) : class$java$lang$String, class$carmel$value$Value == null ? (class$carmel$value$Value = StaticFieldTableModel.class$("carmel.value.Value")) : class$carmel$value$Value, class$java$lang$String == null ? (class$java$lang$String = StaticFieldTableModel.class$("java.lang.String")) : class$java$lang$String};
    protected static final Object[] prototypeValues = new Object[]{"fieldName", BottomValue.BOTTOM, "undef"};
    protected String[] fieldNames;
    protected TreeClassOrInterface classOrInterface;
    static Class class$carmel$value$Value;
    static Class class$java$lang$String;

    public StaticFieldTableModel() {
    }

    public StaticFieldTableModel(TreeClassOrInterface c) {
        this.setClassOrInterface(c);
    }

    public TreeClassOrInterface getClassOrInterface() {
        return this.classOrInterface;
    }

    public void setClassOrInterface(TreeClassOrInterface classOrInterface) {
        if (this.classOrInterface != null) {
            Iterator i = this.classOrInterface.getDeclaredStaticFields().iterator();
            while (i.hasNext()) {
                ((TreeStaticField)i.next()).removeStaticFieldListener(this);
            }
        }
        this.classOrInterface = classOrInterface;
        if (classOrInterface != null) {
            Collection fields = classOrInterface.getDeclaredStaticFields();
            this.fieldNames = new String[fields.size()];
            int index = 0;
            Iterator i = fields.iterator();
            while (i.hasNext()) {
                TreeStaticField field = (TreeStaticField)i.next();
                this.fieldNames[index++] = field.getMemberName();
                field.addStaticFieldListener(this);
            }
            Arrays.sort(this.fieldNames);
        } else {
            this.fieldNames = null;
        }
        this.fireTableDataChanged();
    }

    public void fieldChanged(StaticFieldEvent e) {
        int index = Arrays.binarySearch(this.fieldNames, ((TreeStaticField)e.getSource()).getName());
        if (index >= 0) {
            this.fireTableCellUpdated(index, 1);
        }
    }

    public int getRowCount() {
        return this.fieldNames == null ? 0 : this.fieldNames.length;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int columnIndex) {
        return columnNames[columnIndex];
    }

    public Class getColumnClass(int columnIndex) {
        return columnClasses[columnIndex];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        String fieldName = this.fieldNames[rowIndex];
        if (columnIndex == 0) {
            return fieldName;
        }
        try {
            TreeStaticField field = this.classOrInterface.getDeclaredStaticField(fieldName);
            switch (columnIndex) {
                case 1: {
                    Value value = field.getValue();
                    return value;
                }
                case 2: {
                    String string = field.getType().getJCVMType().getName();
                    return string;
                }
            }
            throw new IndexOutOfBoundsException();
        }
        catch (NoSuchFieldException e) {
            String string = "NoSuchFieldException";
            return string;
        }
    }

    public Object getPrototypeValue(int column) {
        return prototypeValues[column];
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

