/*
 * Decompiled with CFR 0.152.
 */
package carmel.gui;

import carmel.gui.CarmelSourcePanel;
import carmel.interpreter.CarmelSource;
import carmel.parser.LexOrParseException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;

public class SourceErrorDialog
extends JDialog {
    protected Action saveAction;
    protected Action cancelAction;
    JPanel contentPanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel buttonPanel = new JPanel();
    JButton cancelButton = new JButton();
    JButton okButton = new JButton();
    JSplitPane jSplitPane1 = new JSplitPane();
    JScrollPane errorMessageScrollPane = new JScrollPane();
    JTextArea errorMessageTextArea = new JTextArea();
    CarmelSourcePanel carmelSourcePanel = new CarmelSourcePanel();

    public SourceErrorDialog(Frame frame, LexOrParseException exception, String title) {
        super(frame, title, true);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        CarmelSource source = exception.getSource();
        this.cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                SourceErrorDialog.this.hide();
                SourceErrorDialog.this.dispose();
            }
        };
        if (source.isReadOnly()) {
            this.cancelAction.putValue("Name", "OK");
            this.okButton.setAction(this.cancelAction);
        } else {
            this.saveAction = new AbstractAction("OK"){

                public void actionPerformed(ActionEvent event) {
                    try {
                        SourceErrorDialog.this.carmelSourcePanel.save();
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(null, "Error saving changes: ".concat(String.valueOf(String.valueOf(e.getMessage()))), "Error", 0);
                    }
                    SourceErrorDialog.this.hide();
                    SourceErrorDialog.this.dispose();
                }
            };
            this.okButton.setAction(this.saveAction);
            this.cancelAction.putValue("Name", "Cancel");
            this.cancelButton.setAction(this.cancelAction);
            this.buttonPanel.add(this.cancelButton);
        }
        this.errorMessageTextArea.setText(exception.getErrorMessage());
        this.carmelSourcePanel.setCarmelSource(source);
        try {
            this.carmelSourcePanel.highlightLine(exception.getLine() - 1);
            this.carmelSourcePanel.setCaretPosition(exception.getLine() - 1, exception.getColumn() - 1);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)this).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    private void jbInit() throws Exception {
        this.contentPanel.setLayout(this.borderLayout1);
        this.jSplitPane1.setOrientation(0);
        this.errorMessageTextArea.setEditable(false);
        this.errorMessageTextArea.setColumns(80);
        this.errorMessageTextArea.setLineWrap(true);
        this.errorMessageTextArea.setRows(4);
        this.errorMessageTextArea.setWrapStyleWord(true);
        this.carmelSourcePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Source Editor"));
        this.carmelSourcePanel.setRows(20);
        this.carmelSourcePanel.setColumns(80);
        this.errorMessageScrollPane.setBorder(new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Error Message"));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.okButton, null);
        this.contentPanel.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.carmelSourcePanel, "top");
        this.jSplitPane1.add((Component)this.errorMessageScrollPane, "bottom");
        this.errorMessageScrollPane.getViewport().add((Component)this.errorMessageTextArea, null);
    }
}

