/*
 * Decompiled with CFR 0.152.
 */
package carmel.gui;

import carmel.interpreter.CarmelSource;
import carmel.interpreter.FileCarmelSource;
import carmel.interpreter.URLCarmelSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class LoadCarmelSourcePanel
extends JPanel {
    protected Action browseAction;
    protected CarmelFileFilter carmelFileFilter = new CarmelFileFilter(this);
    JFileChooser fileChooser = new JFileChooser();
    BorderLayout borderLayout1 = new BorderLayout();
    JTextField fileNameTextField = new JTextField();
    JButton browseButton = new JButton();
    JLabel messageLabel = new JLabel();

    public LoadCarmelSourcePanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.browseAction = new AbstractAction("Browse..."){

            public void actionPerformed(ActionEvent event) {
                LoadCarmelSourcePanel.this.fileChooser.setSelectedFile(new File(LoadCarmelSourcePanel.this.fileNameTextField.getText().trim()));
                if (LoadCarmelSourcePanel.this.fileChooser.showOpenDialog(null) == 0) {
                    LoadCarmelSourcePanel.this.fileNameTextField.setText(LoadCarmelSourcePanel.this.fileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        };
        this.browseButton.setAction(this.browseAction);
        this.fileChooser.addChoosableFileFilter(this.carmelFileFilter);
        this.fileChooser.setFileFilter(this.carmelFileFilter);
        this.fileNameTextField.requestFocus();
        this.fileNameTextField.setText("http://www.doc.ic.ac.uk/~lj97/project/test.cml");
    }

    public CarmelSource getCarmelSource() throws IOException {
        String url = this.fileNameTextField.getText().trim();
        try {
            FileCarmelSource fileCarmelSource = new FileCarmelSource(new File(url));
            return fileCarmelSource;
        }
        catch (FileNotFoundException e) {
            CarmelSource carmelSource = URLCarmelSource.createCarmelSource(new URL(url));
            return carmelSource;
        }
    }

    public void setFileName(String name) {
        this.fileNameTextField.setText(name);
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.browseButton.setText("Browse...");
        this.messageLabel.setText("Enter file name or URL");
        this.fileNameTextField.setColumns(40);
        this.add((Component)this.fileNameTextField, "Center");
        this.add((Component)this.browseButton, "East");
        this.add((Component)this.messageLabel, "North");
    }

    protected class CarmelFileFilter
    extends FileFilter {
        protected CarmelFileFilter(LoadCarmelSourcePanel this$0) {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".cml");
        }

        public String getDescription() {
            return "Carmel files";
        }
    }
}

