/*
 * Decompiled with CFR 0.152.
 */
package carmel.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ClassPathEditorPanel
extends JPanel {
    protected Action addPathAction;
    JFileChooser fileChooser = new JFileChooser();
    BorderLayout borderLayout1 = new BorderLayout();
    JTextField classPathTextField = new JTextField();
    JButton addPathButton = new JButton();
    JLabel messageLabel = new JLabel();

    public ClassPathEditorPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.addPathAction = new AbstractAction("Add Path..."){

            public void actionPerformed(ActionEvent event) {
                if (ClassPathEditorPanel.this.fileChooser.showDialog(ClassPathEditorPanel.this, "Select") == 0) {
                    StringBuffer classPath = new StringBuffer(ClassPathEditorPanel.this.classPathTextField.getText().trim());
                    if (classPath.length() != 0 && classPath.charAt(classPath.length() - 1) != ';') {
                        classPath.append(';');
                    }
                    ClassPathEditorPanel.this.classPathTextField.setText(classPath.append(ClassPathEditorPanel.this.fileChooser.getSelectedFile().getAbsolutePath()).toString());
                }
            }
        };
        this.addPathButton.setAction(this.addPathAction);
        this.refreshClassPath();
        this.classPathTextField.requestFocus();
    }

    public void refreshClassPath() {
        this.classPathTextField.setText(System.getProperty("java.class.path", "."));
    }

    public void commitChange() {
        System.setProperty("java.class.path", this.classPathTextField.getText().trim());
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.fileChooser.setFileSelectionMode(1);
        this.classPathTextField.setColumns(40);
        this.messageLabel.setText("Set classpath");
        this.add((Component)this.classPathTextField, "Center");
        this.add((Component)this.addPathButton, "East");
        this.add((Component)this.messageLabel, "North");
    }
}

