/*
 * Decompiled with CFR 0.152.
 */
package carmel.gui;

import carmel.gui.ClassLoaderNodeVisitor;
import carmel.interpreter.CarmelClassLoader;
import carmel.interpreter.ClassLoaderEvent;
import carmel.interpreter.ClassLoaderListener;
import carmel.tree.TreeClass;
import carmel.tree.TreeClassOrInterface;
import carmel.tree.TreeConstructor;
import carmel.tree.TreeConstructorOrMethod;
import carmel.tree.TreeInterface;
import carmel.tree.TreeMethod;
import carmel.tree.TreePackage;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ClassLoaderTreeModel
extends DefaultTreeModel
implements ClassLoaderListener {
    protected CarmelClassLoader classLoader;
    protected RootNode rootNode = new RootNode();

    public ClassLoaderTreeModel() {
        super(new DefaultMutableTreeNode());
        this.setRoot(this.rootNode);
    }

    public ClassLoaderTreeModel(CarmelClassLoader classLoader) {
        this();
        this.setClassLoader(classLoader);
    }

    public CarmelClassLoader getClassLoader() {
        return this.classLoader;
    }

    public synchronized void setClassLoader(CarmelClassLoader classLoader) {
        if (this.classLoader != null) {
            this.classLoader.removeClassLoaderListener(this);
        }
        this.classLoader = classLoader;
        if (classLoader != null) {
            classLoader.addClassLoaderListener(this);
            this.rootNode.removeAllChildren();
            Iterator i = classLoader.getPackages().iterator();
            while (i.hasNext()) {
                this.rootNode.addPackageNode(new PackageNode(this, (TreePackage)i.next()));
            }
        }
        this.reload();
    }

    public PackageNode getPackageNode(TreePackage p) {
        return this.rootNode.getPackageNode(p);
    }

    public synchronized void packageLoaded(ClassLoaderEvent event) {
        this.rootNode.addPackageNode(new PackageNode(this, event.getPackage()));
    }

    public class MethodNode
    extends ConstructorOrMethodNode {
        protected MethodNode(ClassLoaderTreeModel this$0, TreeMethod m) {
            super(this$0, m);
        }

        public TreeMethod getMethod() {
            return (TreeMethod)this.method;
        }

        public void visit(ClassLoaderNodeVisitor v) {
            v.visit(this);
        }
    }

    public class ConstructorNode
    extends ConstructorOrMethodNode {
        protected ConstructorNode(ClassLoaderTreeModel this$0, TreeConstructor c) {
            super(this$0, c);
        }

        public TreeConstructor getConstructor() {
            return (TreeConstructor)this.method;
        }

        public void visit(ClassLoaderNodeVisitor v) {
            v.visit(this);
        }
    }

    public abstract class ConstructorOrMethodNode
    extends DefaultMutableTreeNode
    implements Node {
        protected TreeConstructorOrMethod method;

        protected ConstructorOrMethodNode(ClassLoaderTreeModel this$0, TreeConstructorOrMethod method) {
            super(method.getMemberNameWithTypes());
            this.method = method;
        }

        public TreeConstructorOrMethod getConstructorOrMethod() {
            return this.method;
        }

        public abstract void visit(ClassLoaderNodeVisitor var1);
    }

    public class InterfaceNode
    extends ClassOrInterfaceNode {
        protected InterfaceNode(ClassLoaderTreeModel this$0, TreeInterface i) {
            super(i);
            this.addMethods();
        }

        public TreeInterface getInterface() {
            return (TreeInterface)this.classOrInterface;
        }

        public void visit(ClassLoaderNodeVisitor v) {
            v.visit(this);
        }
    }

    public class ClassNode
    extends ClassOrInterfaceNode {
        protected ClassNode(ClassLoaderTreeModel this$0, TreeClass c) {
            super(c);
            TreeMap<String, ConstructorNode> nodeMap = new TreeMap<String, ConstructorNode>();
            Iterator<Object> i = c.getConstructors().iterator();
            while (i.hasNext()) {
                TreeConstructor m = (TreeConstructor)i.next();
                String string = m.getMemberNameWithTypes();
                ClassLoaderTreeModel classLoaderTreeModel = this$0;
                classLoaderTreeModel.getClass();
                nodeMap.put(string, new ConstructorNode(classLoaderTreeModel, m));
            }
            i = nodeMap.values().iterator();
            while (i.hasNext()) {
                this.add((ConstructorNode)i.next());
            }
            this.addMethods();
        }

        public TreeClass getTreeClass() {
            return (TreeClass)this.classOrInterface;
        }

        public void visit(ClassLoaderNodeVisitor v) {
            v.visit(this);
        }
    }

    public abstract class ClassOrInterfaceNode
    extends DefaultMutableTreeNode
    implements Node {
        protected TreeClassOrInterface classOrInterface;

        protected ClassOrInterfaceNode(TreeClassOrInterface classOrInterface) {
            super(classOrInterface.getClassName());
            this.classOrInterface = classOrInterface;
        }

        public void addMethods() {
            TreeMap<String, MethodNode> nodeMap = new TreeMap<String, MethodNode>();
            Iterator<Object> i = this.classOrInterface.getDeclaredMethods().iterator();
            while (i.hasNext()) {
                TreeMethod m = (TreeMethod)i.next();
                nodeMap.put(m.getMemberNameWithTypes(), new MethodNode(ClassLoaderTreeModel.this, m));
            }
            i = nodeMap.values().iterator();
            while (i.hasNext()) {
                this.add((MethodNode)i.next());
            }
        }

        public TreeClassOrInterface getClassOrInterface() {
            return this.classOrInterface;
        }

        public abstract void visit(ClassLoaderNodeVisitor var1);
    }

    public class PackageNode
    extends DefaultMutableTreeNode
    implements Node,
    Comparable {
        protected TreePackage p;
        protected String name;

        protected PackageNode(ClassLoaderTreeModel this$0, TreePackage p) {
            super(p.getName() == null ? "<default>" : p.getName());
            this.p = p;
            this.name = p.getName();
            if (this.name == null) {
                this.name = "<default>";
            }
            TreeMap<String, ClassOrInterfaceNode> nodeMap = new TreeMap<String, ClassOrInterfaceNode>();
            Iterator i = p.interfaces.values().iterator();
            while (i.hasNext()) {
                TreeInterface iface = (TreeInterface)i.next();
                String string = iface.getClassName();
                ClassLoaderTreeModel classLoaderTreeModel = this$0;
                classLoaderTreeModel.getClass();
                nodeMap.put(string, new InterfaceNode(classLoaderTreeModel, iface));
            }
            i = p.classes.values().iterator();
            while (i.hasNext()) {
                TreeClass c = (TreeClass)i.next();
                String string = c.getClassName();
                ClassLoaderTreeModel classLoaderTreeModel = this$0;
                classLoaderTreeModel.getClass();
                nodeMap.put(string, new ClassNode(classLoaderTreeModel, c));
            }
            i = nodeMap.values().iterator();
            while (i.hasNext()) {
                this.add((ClassNode)i.next());
            }
        }

        public TreePackage getPackage() {
            return this.p;
        }

        public int hashCode() {
            return this.p.name.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof PackageNode && this.name.equals(((PackageNode)o).name);
        }

        public int compareTo(Object o) {
            return this.name.compareTo(((PackageNode)o).name);
        }

        public void visit(ClassLoaderNodeVisitor v) {
            v.visit(this);
        }
    }

    public static interface Node {
        public void visit(ClassLoaderNodeVisitor var1);
    }

    public class RootNode
    extends DefaultMutableTreeNode {
        public void addPackageNode(PackageNode node) {
            int index;
            int n = index = this.children == null ? 0 : -Collections.binarySearch(this.children, node) - 1;
            if (index >= 0) {
                this.insert(node, index);
                ClassLoaderTreeModel.this.nodesWereInserted(this, new int[]{index});
            }
        }

        public PackageNode getPackageNode(TreePackage p) {
            int index = this.children == null ? -1 : Collections.binarySearch(this.children, new PackageNode(ClassLoaderTreeModel.this, p));
            return index < 0 ? null : (PackageNode)this.children.get(index);
        }
    }
}

