/*
 * Decompiled with CFR 0.152.
 */
package carmel.gui;

import carmel.interpreter.CarmelSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

public class CarmelSourcePanel
extends JPanel {
    protected JTextArea textArea = new JTextArea();
    protected JLabel label = new JLabel();
    protected Highlighter highlighter;
    protected Object highlightTag;
    protected CaretListener caretListener;
    protected CarmelSource source;
    protected boolean readOnly;
    protected boolean dirty;

    public CarmelSourcePanel() {
        this(false);
    }

    public CarmelSourcePanel(boolean readOnly) {
        this.setLayout(new BorderLayout());
        this.highlighter = this.textArea.getHighlighter();
        try {
            this.highlightTag = this.highlighter.addHighlight(0, 0, new DefaultHighlighter.DefaultHighlightPainter(Color.yellow));
        }
        catch (BadLocationException e) {
            throw new InternalError();
        }
        this.caretListener = new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                if (CarmelSourcePanel.this.source != null) {
                    CarmelSourcePanel.this.updateLabelText();
                }
            }
        };
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                CarmelSourcePanel.this.dirty = true;
            }

            public void removeUpdate(DocumentEvent e) {
                CarmelSourcePanel.this.dirty = true;
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.add((Component)new JScrollPane(this.textArea), "Center");
        this.add((Component)this.label, "South");
        this.setReadOnly(readOnly);
    }

    public boolean isCurrentlyReadOnly() {
        return this.readOnly || this.source == null || this.source.isReadOnly();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.updateCurrentlyReadOnly();
    }

    protected void updateCurrentlyReadOnly() {
        boolean currentlyReadOnly = this.isCurrentlyReadOnly();
        this.textArea.setEditable(!currentlyReadOnly);
        if (currentlyReadOnly) {
            this.textArea.removeCaretListener(this.caretListener);
        } else {
            this.textArea.addCaretListener(this.caretListener);
        }
        this.updateLabelText();
    }

    protected void updateLabelText() {
        if (this.source == null) {
            this.label.setText("No source loaded");
        } else {
            int position = this.textArea.getCaretPosition();
            try {
                int line = this.textArea.getLineOfOffset(position);
                int column = position - this.textArea.getLineStartOffset(line);
                boolean currentlyReadOnly = this.isCurrentlyReadOnly();
                this.label.setText(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.source.getName()))).append(": line ").append(line + 1).append(currentlyReadOnly ? "" : String.valueOf(String.valueOf(new StringBuffer(", column ").append(column + 1)))).append(!this.readOnly && currentlyReadOnly ? " (read only)" : ""))));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    public CarmelSource getCarmelSource() {
        return this.source;
    }

    public void setCarmelSource(CarmelSource source) {
        boolean bl = source == null ? this.source != null : !source.equals(this.source);
        if (bl) {
            if (source == null) {
                this.source = null;
                this.textArea.setText("");
                this.updateLabelText();
            } else {
                try {
                    this.source = source;
                    this.textArea.setText(source.getContents());
                    this.updateLabelText();
                }
                catch (IOException e) {
                    this.source = null;
                    this.textArea.setText("");
                    this.label.setText(String.valueOf(String.valueOf(new StringBuffer("Error reading source ").append(source.getName()).append(": ").append(e.getMessage()))));
                }
            }
            this.dirty = false;
            this.updateCurrentlyReadOnly();
        }
    }

    public int getRows() {
        return this.textArea.getRows();
    }

    public void setRows(int rows) {
        this.textArea.setRows(rows);
    }

    public int getColumns() {
        return this.textArea.getColumns();
    }

    public void setColumns(int columns) {
        this.textArea.setColumns(columns);
    }

    public void save() throws IOException {
        if (!this.dirty || this.source == null || this.source.isReadOnly()) {
            return;
        }
        this.source.setContents(this.textArea.getText());
        this.dirty = false;
    }

    public void highlightLine(int line) throws BadLocationException {
        this.highlighter.changeHighlight(this.highlightTag, this.textArea.getLineStartOffset(line), this.textArea.getLineEndOffset(line));
        this.setCaretPosition(line, 0);
    }

    public void setCaretPosition(int line, int column) throws BadLocationException {
        int y = this.textArea.modelToView((int)this.textArea.getLineStartOffset((int)Math.max((int)(line - 2), (int)0))).y;
        int height = this.textArea.modelToView((int)this.textArea.getLineStartOffset((int)Math.min((int)(line + 2), (int)(this.textArea.getLineCount() - 1)))).y + ((Component)this).getFontMetrics(this.textArea.getFont()).getHeight() - y;
        this.textArea.setCaretPosition(this.textArea.getLineStartOffset(line) + column);
        this.textArea.scrollRectToVisible(new Rectangle(0, y, 0, height));
        this.textArea.requestFocus();
        if (this.isCurrentlyReadOnly()) {
            this.updateLabelText();
        }
    }
}

