/*
 * Decompiled with CFR 0.152.
 */
package carmel.gui;

import carmel.gui.PrototypeValueTableModel;
import carmel.interpreter.CallStack;
import carmel.interpreter.CallStackEvent;
import carmel.interpreter.CallStackListener;
import carmel.interpreter.StackFrame;
import carmel.interpreter.StackFrameEvent;
import carmel.interpreter.StackFrameListener;
import javax.swing.table.AbstractTableModel;

public class CallStackTableModel
extends AbstractTableModel
implements CallStackListener,
StackFrameListener,
PrototypeValueTableModel {
    protected CallStack stack;
    protected static final String[] columnNames = new String[]{"Method", "File location", "PC"};
    protected static final Class[] columnClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CallStackTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CallStackTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CallStackTableModel.class$("java.lang.String")) : class$java$lang$String};
    protected static final Object[] prototypeValues = new Object[]{"test.testtest.ObjectName.methodName(lots.of, parameters, sometimes)", "packageName.cml:999", "handler"};
    static Class class$java$lang$String;

    public CallStackTableModel() {
    }

    public CallStackTableModel(CallStack stack) {
        this.setCallStack(stack);
    }

    public CallStack getCallStack() {
        return this.stack;
    }

    public void setCallStack(CallStack stack) {
        if (this.stack != null) {
            this.stack.removeCallStackListener(this);
        }
        this.stack = stack;
        if (stack != null) {
            stack.addCallStackListener(this);
        }
        this.fireTableDataChanged();
    }

    public void framePushed(CallStackEvent e) {
        e.getFrame().addStackFrameListener(this);
        this.fireTableRowsInserted(0, 0);
    }

    public void framePopped(CallStackEvent e) {
        e.getFrame().removeStackFrameListener(this);
        this.fireTableRowsDeleted(0, 0);
    }

    public void pcChanged(StackFrameEvent e) {
        this.fireTableCellUpdated(0, 1);
        this.fireTableCellUpdated(0, 2);
    }

    public void framePopped(StackFrameEvent e) {
    }

    public int getRowCount() {
        return this.stack == null ? 0 : this.stack.getDepth();
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int columnIndex) {
        return columnNames[columnIndex];
    }

    public Class getColumnClass(int columnIndex) {
        return columnClasses[columnIndex];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        StackFrame frame = this.stack.getFrame(rowIndex);
        switch (columnIndex) {
            case 0: {
                return frame.getMethod().getNameWithTypes();
            }
            case 1: {
                return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(frame.getCarmelSource().getName()))).append(':').append(frame.getPC().getLineNumber())));
            }
            case 2: {
                return frame.getPC().getAddress();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Object getPrototypeValue(int column) {
        return prototypeValues[column];
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

